#!/usr/bin/perl

use Fcntl;
use AnyDBM_File;

$ENV{'PATH_TRANSLATED'} =~ s/\\/\//g;
$ENV{'PATH_TRANSLATED'} =~ s/\/(\w)+\.(\w)+$//;
$ENV{'SCRIPT_FILENAME'} =~ s/\/(\w)+\.(\w)+$//;
if (length($ENV{'SCRIPT_FILENAME'}) >1) { $path = $ENV{'SCRIPT_FILENAME'}; } else {$path=$ENV{'PATH_TRANSLATED'};}

require "$path/cgi-lib.pl";
&ReadParse;

print "Content-type: text/html\n\n";

# Check if WebHost is installed..
open (CONFIG,"$path/config.txt");
$config=<CONFIG>;
close (CONFIG);
if ($config =~ /not_installed/) { &install; exit; }

# Configure
open (CONFIG,"$path/config.txt");
while (<CONFIG>) { if ($_ =~ /\n/) { chop $_; } @config=split(/=/,$_,2); $config{$config[0]}=$config[1]; }
close (CONFIG);

# Open user database if not already open
$flags = O_CREAT | O_RDWR;
$db = "$config{'data_dir'}/users";
tie(%users, 'AnyDBM_File', $db , $flags, 0666) || &error_html("Can't open user database ($db): $!");

if (!$in{'login_password'}) { &login_html; exit; }
if (crypt($in{'login_password'}, as) ne $config{'admin_password'}) { &error_html("Wrong password"); }

if ($in{'cmd'} eq "script_config") {
	if ($demo) { &error_html("Can not perform 'script config' function in demo mode"); }

	if (!$in{'admin_password'}) { $in{'admin_password'} = $config{'admin_password'}; }
	else { $in{'login_password'} = $in{'admin_password'}; $in{'admin_password'} = crypt($in{'admin_password'}, as); }

	open (CONFIG,">$ENV{'SCRIPT_FILENAME'}/config.txt");
	print CONFIG "data_dir=$in{'data_dir'}\n";
	print CONFIG "root_dir=$in{'root_dir'}\n";
	print CONFIG "root_url=$in{'root_url'}\n";
	print CONFIG "site_name=$in{'site_name'}\n";
	print CONFIG "space_limit=$in{'space_limit'}\n";
	print CONFIG "bad_types=$in{'bad_types'}\n";
	print CONFIG "reserved_names=$in{'reserved_names'}\n";
	print CONFIG "admin_password=$in{'admin_password'}\n";
	close (CONFIG);

	open (CONFIG,"$path/config.txt");
	while (<CONFIG>) { if ($_ =~ /\n/) { chop $_; } @config=split(/=/,$_,2); $config{$config[0]}=$config[1]; }
	close (CONFIG);
}

if ($in{'cmd'} eq "modify_user" && $in{'submit'}) {
	if ($demo) { &error_html("Can not perform 'modify user' function in demo mode"); }

	$users{"$in{'username'}"} = "$in{'password'}|$in{'email'}|$in{'real_name'}|$in{'site_description'}";
}

if ($in{'cmd'} eq "remove_user") {
	if ($demo) { &error_html("Can not perform 'remove user' function in demo mode"); }

	opendir (DIR,"$config{'root_dir'}/$in{'user'}");
	@dir = readdir(DIR);
	closedir (DIR);

	foreach $line (@dir) { if (-f "$config{'root_dir'}/$in{'user'}/$line") { unlink ("$config{'root_dir'}/$in{'user'}/$line"); } }
	rmdir ("$config{'root_dir'}/$in{'user'}");
	delete $users{"$in{'user'}"};
}

# Get user list and sort it
while (($key, $value) = each %users) { push (@users, "$key"); }
@users = sort {lc($a) cmp lc($b)} @users;

if ($in{'cmd'} eq "modify_user" && !$in{'submit'}) { @user_info=split(/\|/,$users{"$in{'user'}"}); &modify_user_html; }
else { &main_html; }

sub login_html {
	print qq~
<html>
<head>
<title>Admin Login</title>
</head>
<body bgcolor="#FFFFFF">
<center><big><strong><font face="Arial">yoursite.com</font></strong></big><br><br></center>
<table border="0" cellpadding="0" cellspacing="0" width="100%" >
<tr>
<td><form method="POST">
<center><table border="0" cellpadding="0" cellspacing="0" bgcolor="#000000">
<tr>
<td><table border="0" cellpadding="2" cellspacing="1" width="500">
<tr>
<td bgcolor="#004080"><font face="Arial"><div align="right"><p><em><font color="#FFFFFF"><strong>Admin Login</strong></font></em></font></td>
</tr>
<tr>
<td bgcolor="#C0C0C0"><font face="Arial">Password <input type="password" name="login_password" size="20"></font><p><font face="Arial"><input type="submit" value="Login"></font></td>
</tr>
</table>
</td>
</tr>
</table>
</center></div>
</form>
</td>
</tr>
</table>
</body>
</html>
~;
}

sub main_html {
	print qq~
<html>
<head>
<title>Admin Control</title>
</head>
<body bgcolor="#FFFFFF">
<font FACE="Courier New" SIZE="2">
<form method="POST">
<input type="hidden" name="cmd" value="script_config">
<input type="hidden" name="login_password" value="$in{'login_password'}"><div align="center"><center><table border="0" cellpadding="0" cellspacing="0" bgcolor="#000000">
<tr>
<td><table border="0" cellpadding="2" cellspacing="1" width="500">
<tr>
</font><font SIZE="2"><td bgcolor="#004080"><div align="right"><p></font><font color="#FFFFFF" size="3" face="Arial"><em><strong>Script Config</strong></em></font></td>
<font FACE="Courier New" SIZE="2">
</tr>
<tr>
</font><font SIZE="2"><td bgcolor="#C0C0C0"><table border="0" cellpadding="2" cellspacing="0">
<tr>
<td width="150"><div align="right"><p></font><font size="3" face="Arial">Admin password</font><font SIZE="2"></font></td>
<td><font face="Arial"><input name="admin_password" size="20"></font></td>
</tr>
<tr>
<td width="150" align="right"><font size="3" face="Arial">Data dir</font></td>
<td><font face="Arial"><input type="text" name="data_dir" size="30" value="$config{'data_dir'}"></font></td>
</tr>
<tr>
<td width="150" align="right"><font size="3" face="Arial">Root dir</font></td>
<td><font face="Arial"><input type="text" name="root_dir" size="30" value="$config{'root_dir'}"></font></td>
</tr>
<tr>
<td width="150" align="right"><font size="3" face="Arial">Root url</font></td>
<td><font face="Arial"><input type="text" name="root_url" size="30" value="$config{'root_url'}"></font></td>
</tr>
<tr>
<td width="150" align="right"><font size="3" face="Arial">Site name</font></td>
<td><font face="Arial"><input type="text" name="site_name" size="20" value="$config{'site_name'}"></font></td>
</tr>
<tr>
<td width="150" align="right"><font size="3" face="Arial">Space limit</font></td>
<td><font face="Arial"><input type="text" name="space_limit" size="10" value="$config{'space_limit'}"> KB</font></td>
</tr>
<tr>
<td width="150" align="right"><font size="3" face="Arial">Bad types</font></td>
<td><font face="Arial"><input type="text" name="bad_types" size="20" value="$config{'bad_types'}"></font></td>
</tr>
<tr>
<td width="150" align="right"><font size="3" face="Arial">Reserved names</font></td>
<td><font face="Arial"><input type="text" name="reserved_names" size="20" value="$config{'reserved_names'}"></font></td>
</tr>
</table>
<p><font face="Arial"><input type="submit" value="Submit"></font></td>
</tr>
</table>
</td>
</tr>
</table>
</center></div>
</form>
<div align="center"><center>

<table border="0" cellpadding="0" cellspacing="0" bgcolor="#000000">
<tr>
<td><table border="0" cellpadding="2" cellspacing="1" width="500">
<tr>
<font SIZE="2"><td bgcolor="#004080"><p align="right"></font><font color="#FFFFFF" size="3" face="Arial"><em><strong>Users</strong></em></font></td>
</tr>
<tr>
<td bgcolor="#C0C0C0"><form method="POST">
<input type="hidden" name="cmd" value="modify_user"><input type="hidden" name="login_password" value="$in{'login_password'}"><p><font face="Arial">Modify a user</font></p>
<table border="0" cellpadding="0" cellspacing="0">
<tr>
<td width="150"><font size="3" face="Arial"><div align="right"><p>User</font></td>
<td><font face="Arial" SIZE="2">&nbsp;<select name="user" size="1">
~;
	foreach $line (@users) { print "<option>$line\n"; }
	print qq~
</select></font></td>
</tr>
</table>
<p><input type="submit" value="Submit"></p>
</form>
<form method="POST">
<input type="hidden" name="cmd" value="remove_user"><input type="hidden" name="login_password" value="$in{'login_password'}"><p><font face="Arial">Remove a user</font></p>
<table border="0" cellpadding="0" cellspacing="0">
<tr>
<td width="150"><font size="3" face="Arial"><div align="right"><p>User</font></td>
<td><font face="Arial" SIZE="2">&nbsp;<select name="user" size="1">
~;
	foreach $line (@users) { print "<option>$line\n"; }
	print qq~
</select></font></td>
</tr>
</table>
<p><input type="submit" value="Submit"></p>
</form>
</td>
</tr>
</table>
</td>
</tr>
</table>
</center></div>
</body>
</html>
~;
}

sub error_html {
	($error)=@_;
	print qq~
<html>
<head>
<title>yoursite.com</title>
</head>
<body bgcolor="#FFFFFF" link="#000000" vlink="#FF0000" alink="#800080">
<p align="center"><big><big><strong><font face="Arial">yoursite.com</font></strong></big></big></p>
<form method="POST">
<div align="center"><center><table border="0" cellpadding="0" cellspacing="0" bgcolor="#004080">
<tr>
<td><table border="0" cellpadding="2" cellspacing="1" width="600">
<tr>
<td><font face="Arial" color="#FFFFFF"><strong>Error</strong></font></td>
</tr>
<tr>
<td bgcolor="#0080FF"><font face="Arial">$error</font><p><font face="Arial">Please press 'back' and fix the problem.</font></td>
</tr>
</table>
</td>
</tr>
</table>
</center></div>
</form>
<hr width="80%" noshade size="1" color="#000000">
<p align="center"><font face="Arial"> Copyright 2001 yoursite.com<br>
Get your own <a href="http://www.yoursite.com.com">free version</a>!</font></p>

</body>
</html>
~;
	exit;
}

sub modify_user_html {
	print qq~
<html>
<head>
<title>Modify User</title>
</head>
<body bgcolor="#FFFFFF">
<form method="POST">
<input type="hidden" name="username" value="$in{'user'}">
<input type="hidden" name="cmd" value="modify_user"><input type="hidden" name="login_password" value="$in{'login_password'}">
<div align="center"><center><table border="0" cellpadding="0" cellspacing="0" bgcolor="#000000">
<tr>
<td><table border="0" cellpadding="2" cellspacing="1" width="500">
<tr>
<td bgcolor="#004080"><div align="right"><p><font color="#FFFFFF" size="3" face="Arial"><em><strong>Modify User</strong></em></font></td>
</tr>
<tr>
<font SIZE="2"><td bgcolor="#C0C0C0"><table border="0" cellpadding="2" cellspacing="0">
<tr>
<td width="150"><div align="right"><p><font size="3" face="Arial">Username</font></td>
<td><strong><font face="Arial">$in{'user'}</font></strong></td>
</tr>
<tr>
<td width="150" align="right"><font size="3" face="Arial">Password</font></td>
<td><font face="Arial"><input type="text" name="password" size="20" value="$user_info[0]"></font></td>
</tr>
<tr>
<td width="150" align="right"><font size="3" face="Arial">Email</font></td>
<td><font face="Arial"><input type="text" name="email" size="20" value="$user_info[1]"></font></td>
</tr>
<tr>
<td width="150" align="right"><font size="3" face="Arial">Real name</font></td>
<td><font face="Arial"><input type="text" name="real_name" size="20" value="$user_info[2]"></font></td>
</tr>
<tr>
<td width="150" align="right"><font size="3" face="Arial">Site description</font></td>
<td><font face="Arial"><input type="text" name="site_description" size="20" value="$user_info[3]"></font></td>
</tr>
</table>
<p><font face="Arial"><input type="submit" value="Submit" name="submit"></font></td>
</tr>
</table>
</td>
</tr>
</table>
</center></div>
</form>
</body>
</html>
~;
}

sub install {
	if (!$in{'submit'}) {

		$root_dir = $ENV{'DOCUMENT_ROOT'};
		$data_dir = $ENV{'DOCUMENT_ROOT'}."/data";
		$root_url = "http://".$ENV{'SERVER_NAME'};

		# Try and grab a title..
		if (-f "$ENV{'DOCUMENT_ROOT'}/index.html") {
			open (INDEX,"$ENV{'DOCUMENT_ROOT'}/index.html");
			while (<INDEX>) { $index .= $_; }
			close (INDEX);
			if ($index =~ /<title>(.*)<\/title>/i) { $site_name=$1; }
		} elsif (-f "$ENV{'DOCUMENT_ROOT'}/index.htm") {
			open (INDEX,"$ENV{'DOCUMENT_ROOT'}/index.htm");
			while (<INDEX>) { $index .= $_; }
			close (INDEX);
			if ($index =~ /<title>(.*)<\/title>/i) { $site_name=$1; }
		}

		print qq~
<html>
<head>
<title>Welcome to yoursite.com</title>
</head>
<body bgcolor="#FFFFFF">
<p align="center"><font face="Arial"><big><big><big><strong>Welcome to yoursite.com!</strong></big></big></big></font></p>
<p><font face="Arial">Fill out the following form to yoursite.com in just one step!</font></p>
<form method="POST">
<p><font face="Arial"><strong>Admin password</strong><br>
Please choose a password to use wehn logging in to the admin script.<br>
<input type="text" name="admin_password" size="20"></font></p>
<p><font face="Arial"><strong>Data dir</strong><br>
What is the full path to the data directory? This is where the users database will be kept and must be chmod to 777<br>
<input type="text" name="data_dir" size="40" value="$data_dir"></font></p>
<p><font face="Arial"><strong>Root dir</strong><br>
What is the full path to the root directory? This is where the user directories will be
created and must be chmod to 777<br>
<input type="text" name="root_dir" size="40" value="$root_dir"></font></p>
<p><font face="Arial"><strong>Root url</strong><br>
What is the web url to the root directory?<br>
<input type="text" name="root_url" size="40" value="$root_url"></font></p>
<p><font face="Arial"><strong>Site name</strong><br>
What is the title of your website?<br>
<input type="text" name="site_name" size="40" value="$site_name"></font></p>
<p><font face="Arial"><strong>Space limit</strong><br>
How much space would you like to give each of your WebHost users?<br>
<input type="text" name="space_limit" size="10" value="200"> KB</font></p>
<p><font face="Arial"><strong>Bad types</strong><br>
What types of files would you like to ban from being uploaded?<br>
<input type="text" name="bad_types" size="20" value=".cgi,.pl"></font></p>
<p><font face="Arial"><strong>Reserved names</strong><br>
What usernames/directories would you like to keep for yourself?<br>
<input type="text" name="reserved_names" size="20" value="data,images"></font></p>
<p><font face="Arial"><input type="submit" value="Install" name="submit"></font></p>
</form>
</body>
</html>
~;
	} else {
		if (!$in{'admin_password'}) { &error_html("Missing admin password"); }
		if (!$in{'data_dir'}) { &error_html("Missing data directory"); }
		if (!$in{'root_dir'}) { &error_html("Missing root directory"); }
		if (!$in{'root_url'}) { &error_html("Missing root url"); }
		if (!$in{'site_name'}) { &error_html("Missing site name"); }
		if (!$in{'space_limit'}) { &error_html("Missing space limit"); }

		unless (-d "$in{'data_dir'}") { &error_html("Incorrect path to data directory"); }
		unless (-d "$in{'root_dir'}") { &error_html("Incorrect path to root directory"); }

		if ($in{'root_url'} !~ /http:\/\//i) { &error_html("Invaild root url"); }

		if ($in{'space_limit'} !~ /[0-9]/) { &error_html("Invalid space limit"); }

		$in{'admin_password'} = crypt("$in{'admin_password'}", as);

		open (CONFIG,">$path/config.txt") || &error_html("Could not edit config file, make sure it is chmod to 777: $!");
		print CONFIG "data_dir=$in{'data_dir'}\n";
		print CONFIG "root_dir=$in{'root_dir'}\n";
		print CONFIG "root_url=$in{'root_url'}\n";
		print CONFIG "site_name=$in{'site_name'}\n";
		print CONFIG "space_limit=$in{'space_limit'}\n";
		print CONFIG "bad_types=$in{'bad_types'}\n";
		print CONFIG "reserved_names=$in{'reserved_names'}\n";
		print CONFIG "admin_password=$in{'admin_password'}\n";
		close (CONFIG);

		print qq~
<html>
<head>
<title>Congratulations!</title>
</head>
<body bgcolor="#FFFFFF">
<p align="center"><font face="Arial"><big><big><big><strong>Congratulations!</strong></big></big></big></font></p>
<p><font face="Arial">Installation of WebHost Free is complete and you may now except users.<br>Be sure to try out the following scripts,</font></p>
<p><font face="Arial"><a href="signup.cgi">signup.cgi</a><br>
<a href="manager.cgi">manager.cgi</a><br>
<a href="admin.cgi">admin.cgi</a></font></p>
<p><font face="Arial">If you are happy with the Free version of WebHost be sure to check
out the full version at <a href="http://www.yoursite.com">http://www.yoursite.com</a><br>
Thank you for choosing to use WebHost.</font></p>
</body>
</html>
~;

	}
}