import java.awt.Graphics;
import java.awt.Image;
import java.awt.Color;
import java.lang.Math;
import java.awt.*;

public class CueCards extends java.applet.Applet implements Runnable {
	static boolean  dispCopy = false;
	Image	   origImg, backImg, animImg;
	int	     w1, h1;
	Graphics	backG, finG;
	Thread	  nick;
	int	     frameNo = 0;
	int	     frames = 12;
	int	     period = 50;
	boolean	 needAnim = false;
	boolean	 imLoaded = false;
//	boolean	 imReady = false;
	boolean	 needImage = false;
	boolean	 animReady = false;
	double	  angle1;
	int	     imageNo = 1;
	Color	   backCol;

	public void init () {
		if (!dispCopy) {
			System.out.println ("cueCards v 1.0 for Java");
			System.out.println ("Copyright (c) "
				+ "David Griffiths, 1996. "
				+ "All rights reserved.");
			System.out.println ("For more information visit "
				+ "http://www.demon.co.uk/davidg,");
			System.out.println ("or contact: "
				+ "dgriffiths@msn.com");
			dispCopy = true;
		}
		backCol = new Color (Integer.parseInt(
			getParameter("bgcolor").substring(1),16));
		setBackground (backCol);
		loadImage ();
	}

	public void start () {
		if (nick == null) {
			nick = new Thread (this);
			nick.start ();
		}
	}

	public void stop () {
		if (nick != null) {
			nick.stop ();
			nick = null;
		}
	}

	public void run () {
		while (nick != null) {
			if (needImage) {
				needImage = false;
				loadImage ();
			}
			if (needAnim) {
				needAnim = false;					
				animReady = false;
				createAnim ();
			}
			repaint ();
//			if (imReady && (frameNo < frames)) {
			if (frameNo < frames) {
				if (frameNo == (frames - 1))
					needAnim = true;
				frameNo++;
			}
			else if (frameNo >= frames) {
				if (frameNo == frames)
					needImage = true;
				if (frameNo == (frames << 1) - 1) {
					frameNo = 0;
				}
				frameNo++;
			}
			try     {Thread.sleep (50);}
			catch   (InterruptedException e) {}
		}
	}

	public void loadImage () {
		MediaTracker tracker = new MediaTracker(this);
		String nextImage = getParameter ("image" + imageNo);
		if (nextImage == null) {
			imageNo = 1;
			nextImage = getParameter ("image1");
		}
		imageNo++;
		imLoaded = false;
//		imReady = false;
		origImg = getImage (getDocumentBase(), nextImage);

		tracker.addImage(origImg, 0);

		// Wait until all images are fully loaded
		//------------------------------------------------------------------
		try tracker.waitForAll(); catch (InterruptedException e) {}

		w1 = origImg.getWidth (this);
		h1 = origImg.getHeight (this);
//		if ((w1 != -1) && (h1 != -1))
//			imReady = true; 
	}

	public void rotateImage (Graphics g, double angle) {
		double twistAngle = angle;
		double quart = (Math.PI / 2.0);
		double oct = (Math.PI / 4.0);

		if (twistAngle > oct) {
			shearY (g, 1);
			shearX (g, 1);
			shearY (g, 1);
			twistAngle -= quart;
		}
			
		shearX(g, Math.tan (twistAngle / 2.0));
		shearY(g, Math.sin (twistAngle));
		shearX(g, Math.tan (twistAngle / 2.0));
	}

	public void shearX (Graphics g, double shearing) {
		double l;
		for (int i = 0; i < (h1<<1); i++) {
			l = ((double)i * -shearing)
				+ ((double)h1 * shearing);
			g.copyArea (0, i, ((w1 * 3) >> 1), 1, (int)l, 0);
			g.drawLine ((int)l, i, 0, i);
			g.drawLine ((int)l + ((w1 * 3) >> 1),
				i, (w1 * 3) >> 1, i);
		}
	}

	public void shearY (Graphics g, double shearing) {
		double l;
		for (int i = 0; i < ((w1 * 3) >> 1); i++) {
			l = ((double)i * shearing);
			g.copyArea (i, 0, 1, h1<<1, 0, (int)l);
			g.drawLine (i, (int)l, i, 0);
			g.drawLine (i, (int)l + (h1<<1), i, h1<<1);
		}
	}

	public void update (Graphics g) {
		paint (g);
	}

	public void paint (Graphics g) {
//		if ((frameNo < frames) && imReady) {
		if (frameNo < frames) {
			g.drawImage (origImg,
				0, (frameNo * frameNo * h1
				/ ((frames - 1) * (frames - 1))) - h1,
				this);
		}
		else if ((frameNo == frames) && animReady) {
			g.drawImage (origImg,
				0, 0, this);
		}
		else if ((frameNo > frames) && animReady) {
			int i = frameNo - frames;
			g.drawImage (animImg, 0, (-i * h1), this);
		}
		else   
			if (origImg != null)
				g.drawImage (origImg, 0, 400, this); 
	}

	public void createAnim () {
		System.gc();
		if (backImg == null) {
			backImg = createImage ((w1 * 3) >> 1, h1<<1);
			backG = backImg.getGraphics();
			animImg = createImage (w1, frames * h1);
			finG = animImg.getGraphics();
			backG.setColor (backCol);
		}
		for (int phase = 0; phase < frames; phase++) {
			backG.fillRect (0,0,w1,h1<<1);
			backG.drawImage (origImg, 0, 0, this);
			rotateImage (backG, 0.6 * Math.PI
					* (double) phase * (double) phase
					/ (double) frames / (double) frames);
			finG.drawImage (backImg,
				0, phase * h1, this);
		}
		animReady = true;
	}
}
