// -----------------------------------------------------------
// tscroll.java                 | class tscroll
// -----------------------------------------------------------
// ------------------- tScroll V 3.01 ------------------------
// Scrolling Texte Message - FreeWare -
// Author : R. BERTHOU
// E-Mail : rbl@berthou.com
// URL    : http://www.berthou.com
// -----------------------------------------------------------
// If you add new function in this applet send me a new file
// -
// Si vous ajoutez de nouvelles fonction a l'applet envoyez moi
// le source.
// -----------------------------------------------------------
// Ver  * Author     *  DATE    * Description
// ....................DD/MM/YY...............................
// 3.01 * R. BERTHOU * 13/01/00 * correct a bug in cSep param
// 3.00 * R. BERTHOU * 13/11/99 * reduce size / can get all data in param
// 2.51 * Pi. CRAMPON* 13/11/99 * Ajout du paramtre StopOnMouseOver
// 2.50 * Pi. CRAMPON* 11/11/99 * Arrt du dfilement lors d'un passage
//  "   * pierrick.crampon@     * Ractivation du dfilement
//  "   *            freesbee.fr* Affichage du curseur lien
// 2.21 * Joop Vriend* 01/08/98 * Correct a bug in horizontal scroll
//  "   *  joop.vriend@ddnh.nl  *
// 2.20 * R. BERTHOU * ??/02/98 * Add mediatracker
// 2.11 * R. BERTHOU * 26/01/98 * Correct bug in Array execption
// 2.10 * R. BERTHOU * 02/10/97 * Add foreground Image
// 2.03 * R. BERTHOU * 02/08/97 * Add target option
// 2.02 * R. BERTHOU * 01/07/97 * Add iScroll 3 (Fade Effect)
//  "   *                       * iScroll 4 (no Effet)
// 2.01 * R. BERTHOU * 27/06/97 * Add Scroll Type (0, 1, 2)
// 2.00 * R. BERTHOU * 26/05/97 * Input Data in file 
//  "   *                       * Add rd2.java 
// -----------------------------------------------------------

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Image;
import java.awt.Event;
import java.awt.MediaTracker;
import java.awt.Cursor;

import java.io.DataInputStream ;

import java.util.Vector ;
import java.util.Enumeration ;

import java.net.URL;

import rd2 ;


public class tscroll extends java.applet.Applet implements Runnable {

	// Declare the controlling thread for the applet
	public	Vector dFile = new Vector( 5, 5 );
	
	Thread scrollmessage;

	private String[] ligne = new String[20] ;	// texte du message reformat
	
	// Declare the details for the message to be displayed

	int	iLigne		;	// Nombre de lignes du message
	int s_h			;	// Longueur du message
	int s_v			;	// Hauteur du message
	
	int iMax		;	// Nombre de Message 
	int iActif = 999;	// Message Actif
	boolean iCharge = true ; 
	boolean iEffect = false ;

	int cBk = 0x000000 ;		// Nombre de Message 
	int cTx = 0xFFFFFF ;		// Message Actif
	int iR, iB, iG ;
	int iRp, iBp, iGp ;
	int iR2, iB2, iG2 ;
	int iR2p, iB2p, iG2p ;

	private char        cSep = ';'   ;
	private boolean     bLoc = false ;

	// Variables controlling the display of the message

	int 	x_coord,		// present x-position
			y_coord,		// present y-position
			x_effect,		//
			speed,			// scrolling amount
			iScroll,		// (integer) Type de dfilement
			iPause,			// (integer) pause 
			delay;			// scrolling speed


	// for storing the dimensions of the applet
	int appletWidth, appletHeight;



	// for double buffering to prevent flicker
	Image offScreenImage;
	Image fdImg = null; 				// Image de fond
	Image gdImg = null; 				// Image de fond
	Graphics offScreen;


	// Font control variables
	Font wordFont;
	FontMetrics wordMetrics;
	
	//Arret du dfilement||Stop of scrolling of the message
	boolean bStp = false;

/*
	private Color stringToColor(String paramValue)
	{
		int red;
		int green;
		int blue;

		red = (Integer.decode("0x" + paramValue.substring(0,2))).intValue();
		green = (Integer.decode("0x" + paramValue.substring(2,4))).intValue();
		blue = (Integer.decode("0x" + paramValue.substring(4,6))).intValue();

		return new Color(red,green,blue);
	}
*/
	// Applet initialisation routine
	public void init() {
		this.setCursor(new Cursor(12));
		// Temporary storage space
		String temp;

		// get the size of the applet
		appletWidth = size().width;
		appletHeight = size().height;


		// initialise the double buffering screen
		try {
			offScreenImage = createImage (appletWidth, appletHeight);
			offScreen = offScreenImage.getGraphics ();
		} catch (Exception e) {
			offScreen = null;
		}

		wordFont = getFont();
		wordMetrics = getFontMetrics (wordFont);

		// get the speed of the scrolling
		temp = getParameter("speed");
		speed= (temp==null) ? 1 : Integer.parseInt( temp );

		temp = getParameter("delay");
		delay= (temp==null) ? 100 : Integer.parseInt( temp );

		temp = getParameter("pause");
		iPause= (temp==null) ? 0 : Integer.parseInt( temp );
		
		temp = getParameter("tscr");
		iScroll= (temp==null) ? 1 : Integer.parseInt( temp );

		MediaTracker  trk = new MediaTracker(this) ;

		temp = getParameter("image");
		if (temp != null) {
	      	fdImg = getImage(getCodeBase(), temp) ;
			trk.addImage(fdImg, 0) ;
		}


		temp = getParameter("fgimg");
		if (temp != null) {
	      	gdImg = getImage(getCodeBase(), temp) ;
			trk.addImage(gdImg, 0) ;
		}

		try	  { trk.waitForAll() ; }
		catch (InterruptedException e) {	}

		temp = getParameter("csep");
		if (temp != null)
			cSep = temp.charAt(0) ;

		temp = getParameter("file");
		readFile(temp) ;

		temp = getParameter("StopOnMouseOver");
		bStp= (temp==null) ? false : temp.equals("1") ;


} // end of init


public void Charge() {
	iActif++ ;
	if (iActif >= iMax)
		iActif = 0 ;

	String s ;
	s = new String( ((rd2)dFile.elementAt(iActif)).sM ) ;
	if (iScroll==1) {		// dfilement horizontal
		ligne[0] = new String( s ) ;
		iLigne = 1 ;
	}
	else {					// dfilement vertical
		int iE = 0, iB = 0 ;
		iLigne = 0 ;
		iE = s.indexOf("\\n", iB) ;
		while(iE > -1) {
			ligne[iLigne++] = s.substring(iB, iE) ;
			iB = iE+2 ;
			iE = s.indexOf("\\n", iB) ;
		}
       	ligne[iLigne++] = s.substring(iB, s.length()) ;
	}

	iCharge = false ;
	if ( ((rd2)dFile.elementAt(iActif)).wFont != null ) {
		wordFont = ((rd2)dFile.elementAt(iActif)).wFont ;
		wordMetrics = getFontMetrics (wordFont);
	}
	s_h=-wordMetrics.stringWidth(ligne[0]);
	s_v=wordMetrics.getHeight();

}


public void readFile(String f) {
	String sS ;
	rd2  s ;
	int ii = 0 ;

	dFile.removeAllElements()	;

	// open stream to a file which name is expressed relative to the document URL
	DataInputStream fis = null ;

	try {
		fis = new DataInputStream( (new URL( getCodeBase(), f )).openStream() ) ;
		bLoc = false ;
	} catch( Exception e ) {
		bLoc = true ;
	}	// A traiter

	// parser loop
	while ( true ) {
		s = new rd2();
 
		if (bLoc) {
			sS = getParameter(f + ii);
			ii++ ;
		}
		else {
			try {
				sS = fis.readLine() ;
			} catch( Exception e ) { break ; }	
		}

		if (s.get( s, sS, cSep )) 
			dFile.addElement( s );
		else 
			break ;
	}

	iMax  = dFile.size() ;

}



// control the starting of the applet
public void start() {

	// Set the initial coordinates
	if (iScroll==1) {		// dfilement horizontal
		y_coord = appletHeight/2 + (wordMetrics.getHeight()-wordMetrics.getDescent())/2;
		x_coord = appletWidth;
     }
     else {					// dfilement vertical
		x_coord = (appletWidth + s_h) / 2 ;
		y_coord = appletHeight + wordMetrics.getHeight() ;
     }

	// start the thread
	scrollmessage = new Thread(this);
	scrollmessage.start();

} // end of start



	// control the stopping of the applet
public void stop() {
	scrollmessage.stop();
} // end of stop



// control the running of the applet

public void run() {
	// set the priority of the thread to low
	Thread.currentThread().setPriority(Thread.MIN_PRIORITY);

	// loop continuously
	while(true) {
		// values for working out the constant delay
		long thisTick, waitTick;

		// calculate the tick to wait for
		waitTick = System.currentTimeMillis() + delay;

		// update the screen
		if (iEffect == false) {
			if (iScroll==1) {
				x_coord -= speed;
				if (x_coord<s_h) {
					iCharge = true; // Load next line
					x_coord = appletWidth;
				}
			}
			else {
				y_coord -= speed;
				if (y_coord<(-s_v * (iLigne-1)))
					y_coord = appletHeight + wordMetrics.getHeight() ;
			}
		}

		repaint ();

		// Attendre 
		if ((iEffect == false) && (y_coord >= s_v) && ((y_coord-speed) < s_v)) {
			waitTick += iPause ;
			x_effect = -1 ;
		}
		// Wait horizontal too
		if ((iEffect == false) && (x_coord >= 0) && (x_coord-speed < 0))
			waitTick += iPause;


		// delay for the appropriate amount of time
		thisTick = System.currentTimeMillis();

		if ( thisTick<waitTick ) {
			try {
				Thread.currentThread().sleep( (int)(waitTick-thisTick));
			} catch (InterruptedException e) {}
		}

		if (x_effect == -1) {
			x_effect = 0 ;
			if (iScroll != 4)
				iEffect = true ;
			else {
				iCharge = true ;
				x_coord = (appletWidth + s_h) / 2 ;
				y_coord = appletHeight + wordMetrics.getHeight() ;
			}
		}

	} 	// end of loop

  } // end of run

  public boolean mouseDown(Event e, int x, int y){
	  if ( ((rd2)dFile.elementAt(iActif)).sU != null) {
		URL clickDest ;
		try{
			if ( ((rd2)dFile.elementAt(iActif)).sU.charAt(0) == '.')
				clickDest = new URL(getCodeBase(), ((rd2)dFile.elementAt(iActif)).sU );
			else
				clickDest = new URL(((rd2)dFile.elementAt(iActif)).sU);
			getAppletContext().showDocument(clickDest, ((rd2)dFile.elementAt(iActif)).sTarg);
		}catch(Exception z) {
				showStatus("Bad URL! =" + ((rd2)dFile.elementAt(iActif)).sU );
		}										
	  }

	  return(true);
   }

  public boolean mouseEnter(Event e, int x, int y){
		showStatus(((rd2)dFile.elementAt(iActif)).sU);
		if (bStp) {scrollmessage.suspend();}
		return(true);
  }

  public boolean mouseExit(Event e, int x, int y){
	  showStatus("");
	  if (bStp) {scrollmessage.resume();}
	  return(true);
  }



	// Called when the applet needs to be painted
	// calls the flicker free updating system
	public void paint (Graphics g) {
		update(g);
	} // end of paint



	// Draw the applet without flicker
	public synchronized void update(Graphics g) {
		if (offScreen!=null) {
			paintApplet(offScreen);
			g.drawImage(offScreenImage,0,0,this);
		}  else
			paintApplet(g);
	} // end of update


	// Paint the applet into whatever image
	public void paintApplet(Graphics g) {
		if (iCharge) {
			Charge() ;
			Color cTemp, cTemp2 ;

			if ( ((rd2)dFile.elementAt(iActif)).iB > -1) 
				cBk = ((rd2)dFile.elementAt(iActif)).iB ;

	//	setBackground(new Color(((rd2)dFile.elementAt(iActif)).iB) ) ;
	
			if ( ((rd2)dFile.elementAt(iActif)).iT > -1) 
				cTx = ((rd2)dFile.elementAt(iActif)).iT ;

			// set the font in the graphics context
			g.setFont (wordFont);

			if ( (iActif+1) == iMax)
				iR = 0 ;
			else
				iR = iActif + 1 ;

			if ( ((rd2)dFile.elementAt(iR)).iB > -1) {
				cTemp = new Color(((rd2)dFile.elementAt(iR)).iB ) ;
			}
			else {
				cTemp = new Color(cBk) ;
			}

			cTemp2 = new Color(cBk) ;
			iRp = cTemp2.getRed() - cTemp.getRed()  ;
			iBp = cTemp2.getBlue() - cTemp.getBlue()  ;
			iGp = cTemp2.getGreen() - cTemp.getGreen()  ;

			cTemp2 = new Color(cTx) ;
			iR2 = cTemp2.getRed() ;
			iB2 = cTemp2.getBlue() ;
			iG2 = cTemp2.getGreen() ;

			iR2p = iR2 - cTemp.getRed()  ;
			iB2p = iB2 - cTemp.getBlue()  ;
			iG2p = iG2 - cTemp.getGreen()  ;

			cTemp = new Color(cBk) ;
			iR = cTemp.getRed() ;
			iB = cTemp.getBlue() ;
			iG = cTemp.getGreen() ;

		}

		g.clearRect(0,0,appletWidth,appletHeight);

		if (iEffect && (iScroll == 3)) {
			g.setColor ( new Color ( iR - ((iRp*x_effect)/20),
									 iG - ((iGp*x_effect)/20),
									 iB - ((iBp*x_effect)/20)) );
		}
		else
			g.setColor ( new Color ( cBk ) );

		g.fillRect(0, 0, appletWidth, appletHeight ) ;

		if (iEffect && (iScroll == 3)) {
			g.setColor ( new Color ( iR2 - ((iR2p*x_effect)/20),
									 iG2 - ((iG2p*x_effect)/20),
									 iB2 - ((iB2p*x_effect)/20)) );
		}
		else
			g.setColor ( new Color ( cTx ) );

		if (fdImg != null)
			g.drawImage(fdImg,0,0, appletWidth, appletHeight, this);
      

     	int i = 0 ;
     	while (i < iLigne) {
			if (iScroll != 1) {
				if (((rd2)dFile.elementAt(iActif)).iScr == 1)
					x_coord = (appletWidth - wordMetrics.stringWidth(ligne[i])) - 5 ;
				else
					if (((rd2)dFile.elementAt(iActif)).iScr == 2)
		  				x_coord = 5 ;
					else
		      			x_coord = (appletWidth - wordMetrics.stringWidth(ligne[i])) / 2 ;
			}
			g.drawString (ligne[i], x_coord, y_coord + (s_v * i) );
			i++ ;
        }


		if (iEffect) {
			x_effect++ ;
			if (iScroll == 2)
				g.fillRect(0, 0,
						   appletWidth * x_effect / 20,
						   appletHeight* x_effect / 20 ) ;
			if (x_effect >= 20) {
				iEffect = false ;
				iCharge = true ;
				x_effect = 0 ;
				// Set the initial coordinates
				if (iScroll==1) {		// dfilement horizontal
					y_coord = appletHeight/2 + (wordMetrics.getHeight()-wordMetrics.getDescent())/2;
					x_coord = appletWidth;
				}
				else {					// dfilement vertical
					x_coord = (appletWidth + s_h) / 2 ;
					y_coord = appletHeight + wordMetrics.getHeight() ;
				}
			}
		}

		if (gdImg != null)
			g.drawImage(gdImg,0,0, appletWidth, appletHeight, this);


	} // end of paintApplet


	// Return the information on the applet
	public String getAppletInfo() {
		return "tscroll v3.00 * Message Applet (Copyright 1996..99) by R. BERTHOU(rbl@berthou.com)";
	} // end of getAppletInfo


} // end of class ScrollingMessage
