/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringUtil;

public class HsqlDateTime {
    private static Locale defaultLocale = Locale.UK;
    private static long currentDateMillis;
    public static final Calendar tempCalDefault;
    public static final Calendar tempCalGMT;
    private static final Date tempDate;
    private static final String sdfdPattern = "yyyy-MM-dd";
    static SimpleDateFormat sdfd;
    private static final String sdftPattern = "HH:mm:ss";
    static SimpleDateFormat sdft;
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss";
    static SimpleDateFormat sdfts;
    private static final String sdftsSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    static SimpleDateFormat sdftsSys;
    private static Date sysDate;
    private static final char[][] dateTokens;
    private static final String[] javaDateTokens;
    private static final int[] sqlIntervalCodes;
    private static final char e = '\uffff';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDateSeconds(String string) {
        try {
            SimpleDateFormat simpleDateFormat = sdfd;
            synchronized (simpleDateFormat) {
                Date date = sdfd.parse(string);
                return date.getTime() / 1000L;
            }
        }
        catch (Exception exception) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(long l) {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l * 1000L);
            return sdfd.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimestampSeconds(String string) {
        try {
            SimpleDateFormat simpleDateFormat = sdfts;
            synchronized (simpleDateFormat) {
                Date date = sdfts.parse(string);
                return date.getTime() / 1000L;
            }
        }
        catch (Exception exception) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTimestampString(StringBuffer stringBuffer, long l, int n, int n2) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            tempDate.setTime(l * 1000L);
            stringBuffer.append(sdfts.format(tempDate));
            if (n2 > 0) {
                stringBuffer.append('.');
                stringBuffer.append(StringUtil.toZeroPaddedString(n, 9, n2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long l) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l);
            return sdfts.format(sysDate);
        }
    }

    public static synchronized long getCurrentDateMillis(long l) {
        if (l - currentDateMillis >= 86400000L) {
            currentDateMillis = HsqlDateTime.getNormalisedDate(l);
        }
        return currentDateMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSytemTimeString() {
        SimpleDateFormat simpleDateFormat = sdftsSys;
        synchronized (simpleDateFormat) {
            sysDate.setTime(System.currentTimeMillis());
            return sdftsSys.format(sysDate);
        }
    }

    public static void resetToDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void resetToTime(Calendar calendar) {
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(14, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisToCalendar(Calendar calendar, long l) {
        calendar.clear();
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            tempCalGMT.setTimeInMillis(l);
            calendar.set(tempCalGMT.get(1), tempCalGMT.get(2), tempCalGMT.get(5), tempCalGMT.get(11), tempCalGMT.get(12), tempCalGMT.get(13));
            return calendar.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisFromCalendar(Calendar calendar, long l) {
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            tempCalGMT.clear();
            calendar.setTimeInMillis(l);
            tempCalGMT.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
            return tempCalGMT.getTimeInMillis();
        }
    }

    public static void setTimeInMillis(Calendar calendar, long l) {
        calendar.setTimeInMillis(l);
    }

    public static long getTimeInMillis(Calendar calendar) {
        return calendar.getTimeInMillis();
    }

    public static long convertToNormalisedTime(long l) {
        return HsqlDateTime.convertToNormalisedTime(l, tempCalGMT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedTime(long l, Calendar calendar) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToDate(calendar);
            long l2 = HsqlDateTime.getTimeInMillis(calendar);
            return l - l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedDate(long l, Calendar calendar) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToDate(calendar);
            return HsqlDateTime.getTimeInMillis(calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(long l) {
        Calendar calendar;
        Calendar calendar2 = calendar = tempCalGMT;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToTime(calendar);
            return HsqlDateTime.getTimeInMillis(calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(Calendar calendar, long l) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToTime(calendar);
            return HsqlDateTime.getTimeInMillis(calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(long l) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalGMT, l);
            HsqlDateTime.resetToDate(tempCalGMT);
            return HsqlDateTime.getTimeInMillis(tempCalGMT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(Calendar calendar, long l) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            HsqlDateTime.setTimeInMillis(calendar, l);
            HsqlDateTime.resetToDate(calendar);
            return HsqlDateTime.getTimeInMillis(calendar);
        }
    }

    public static int getZoneSeconds(Calendar calendar) {
        return (calendar.get(15) + calendar.get(16)) / 1000;
    }

    public static int getZoneMillis(Calendar calendar, long l) {
        return calendar.getTimeZone().getOffset(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDateTimePart(long l, int n) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            tempCalGMT.setTimeInMillis(l);
            return tempCalGMT.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTruncatedPart(long l, int n) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            tempCalGMT.setTimeInMillis(l);
            switch (n) {
                case 262: {
                    int n2 = tempCalGMT.get(1);
                    int n3 = tempCalGMT.get(3);
                    tempCalGMT.clear();
                    tempCalGMT.set(1, n2);
                    tempCalGMT.set(3, n3);
                    break;
                }
                default: {
                    HsqlDateTime.zeroFromPart(tempCalGMT, n);
                }
            }
            return tempCalGMT.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRoundedPart(long l, int n) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            tempCalGMT.setTimeInMillis(l);
            switch (n) {
                case 101: {
                    if (tempCalGMT.get(2) <= 6) break;
                    tempCalGMT.add(1, 1);
                    break;
                }
                case 102: {
                    if (tempCalGMT.get(5) <= 15) break;
                    tempCalGMT.add(2, 1);
                    break;
                }
                case 103: {
                    if (tempCalGMT.get(11) <= 11) break;
                    tempCalGMT.add(5, 1);
                    break;
                }
                case 104: {
                    if (tempCalGMT.get(12) <= 29) break;
                    tempCalGMT.add(11, 1);
                    break;
                }
                case 105: {
                    if (tempCalGMT.get(13) <= 29) break;
                    tempCalGMT.add(12, 1);
                    break;
                }
                case 106: {
                    if (tempCalGMT.get(14) <= 499) break;
                    tempCalGMT.add(13, 1);
                    break;
                }
                case 262: {
                    int n2 = tempCalGMT.get(1);
                    int n3 = tempCalGMT.get(3);
                    int n4 = tempCalGMT.get(7);
                    if (n4 > 3) {
                        ++n3;
                    }
                    tempCalGMT.clear();
                    tempCalGMT.set(1, n2);
                    tempCalGMT.set(3, n3);
                    return tempCalGMT.getTimeInMillis();
                }
            }
            HsqlDateTime.zeroFromPart(tempCalGMT, n);
            return tempCalGMT.getTimeInMillis();
        }
    }

    static void zeroFromPart(Calendar calendar, int n) {
        switch (n) {
            case 101: {
                calendar.set(2, 0);
            }
            case 102: {
                calendar.set(5, 1);
            }
            case 103: {
                calendar.set(11, 0);
            }
            case 104: {
                calendar.set(12, 0);
            }
            case 105: {
                calendar.set(13, 0);
            }
            case 106: {
                calendar.set(14, 0);
            }
        }
    }

    public static Date toDate(String string, String string2, SimpleDateFormat simpleDateFormat) {
        Date date;
        String string3 = HsqlDateTime.toJavaDatePattern(string2);
        int n = string3.indexOf("*IY");
        if (n >= 0) {
            throw Error.error(3472);
        }
        n = string3.indexOf("*WW");
        if (n >= 0) {
            throw Error.error(3472);
        }
        n = string3.indexOf("*W");
        if (n >= 0) {
            throw Error.error(3472);
        }
        try {
            simpleDateFormat.applyPattern(string3);
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            throw Error.error(3407, exception.toString());
        }
        return date;
    }

    public static String toFormattedDate(Date date, String string, SimpleDateFormat simpleDateFormat) {
        int n;
        int n2;
        int n3;
        Calendar calendar;
        String string2 = HsqlDateTime.toJavaDatePattern(string);
        try {
            simpleDateFormat.applyPattern(string2);
        }
        catch (Exception exception) {
            throw Error.error(3472);
        }
        String string3 = simpleDateFormat.format(date);
        int n4 = string3.indexOf("*IY");
        if (n4 >= 0) {
            calendar = simpleDateFormat.getCalendar();
            n3 = 3;
            n2 = string3.indexOf("*IYYY");
            if (n2 >= 0) {
                n3 = 5;
                n4 = n2;
            }
            n = calendar.get(1);
            int n5 = calendar.get(3);
            if (n5 == 1 && calendar.get(6) > 360) {
                ++n;
            }
            String string4 = String.valueOf(n);
            if (n3 == 3) {
                string4 = string4.substring(string4.length() - 2);
            }
            StringBuilder stringBuilder = new StringBuilder(string3);
            stringBuilder.replace(n4, n4 + n3, string4);
            string3 = stringBuilder.toString();
        }
        if ((n4 = string3.indexOf("*WW")) >= 0) {
            calendar = simpleDateFormat.getCalendar();
            n3 = 3;
            n2 = calendar.get(6);
            n = (n2 - 1) / 7 + 1;
            StringBuilder stringBuilder = new StringBuilder(string3);
            stringBuilder.replace(n4, n4 + n3, String.valueOf(n));
            string3 = stringBuilder.toString();
        }
        if ((n4 = string3.indexOf("*W")) >= 0) {
            calendar = simpleDateFormat.getCalendar();
            n3 = 2;
            n2 = calendar.get(5);
            n = (n2 - 1) / 7 + 1;
            StringBuilder stringBuilder = new StringBuilder(string3);
            stringBuilder.replace(n4, n4 + n3, String.valueOf(n));
            string3 = stringBuilder.toString();
        }
        return string3;
    }

    public static String toJavaDatePattern(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        Tokenizer tokenizer = new Tokenizer();
        for (int i = 0; i <= n; ++i) {
            char c;
            char c2 = c = i == n ? (char)'\uffff' : (char)string.charAt(i);
            if (tokenizer.isInQuotes()) {
                if (tokenizer.isQuoteChar(c)) {
                    c = '\'';
                } else if (c == '\'') {
                    stringBuffer.append(c);
                }
                stringBuffer.append(c);
                continue;
            }
            if (tokenizer.next(c, i)) continue;
            if (tokenizer.consumed) {
                int n2 = tokenizer.getLastMatch();
                stringBuffer.append(javaDateTokens[n2]);
                i = tokenizer.matchOffset;
            } else if (tokenizer.isQuoteChar(c)) {
                c = '\'';
                stringBuffer.append(c);
            } else if (tokenizer.isLiteral(c)) {
                stringBuffer.append(c);
            } else if (c != '\uffff') {
                throw Error.error(3407, string.substring(i));
            }
            tokenizer.reset();
        }
        if (tokenizer.isInQuotes()) {
            throw Error.error(3407);
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    public static int toStandardIntervalPart(String string) {
        int n = string.length();
        Tokenizer tokenizer = new Tokenizer();
        for (int i = 0; i <= n; ++i) {
            char c;
            char c2 = c = i == n ? (char)'\uffff' : (char)string.charAt(i);
            if (tokenizer.next(c, i)) continue;
            int n2 = tokenizer.getLastMatch();
            if (n2 >= 0) {
                return sqlIntervalCodes[n2];
            }
            return -1;
        }
        return -1;
    }

    static /* synthetic */ char[][] access$200() {
        return dateTokens;
    }

    static {
        tempCalDefault = new GregorianCalendar();
        tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale);
        tempDate = new Date(0L);
        sdfd = new SimpleDateFormat(sdfdPattern);
        sdft = new SimpleDateFormat(sdftPattern);
        sdfts = new SimpleDateFormat(sdftsPattern);
        sdftsSys = new SimpleDateFormat(sdftsSysPattern);
        tempCalGMT.setLenient(false);
        sdfd.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfd.setLenient(false);
        sdft.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdft.setLenient(false);
        sdfts.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfts.setLenient(false);
        currentDateMillis = HsqlDateTime.getNormalisedDate(System.currentTimeMillis());
        sysDate = new Date();
        dateTokens = new char[][]{{'R', 'R', 'R', 'R'}, {'I', 'Y', 'Y', 'Y'}, {'Y', 'Y', 'Y', 'Y'}, {'I', 'Y'}, {'Y', 'Y'}, {'B', 'C'}, {'B', '.', 'C', '.'}, {'A', 'D'}, {'A', '.', 'D', '.'}, {'M', 'O', 'N'}, {'M', 'O', 'N', 'T', 'H'}, {'M', 'M'}, {'D', 'A', 'Y'}, {'D', 'Y'}, {'W', 'W'}, {'I', 'W'}, {'D', 'D'}, {'D', 'D', 'D'}, {'W'}, {'H', 'H', '2', '4'}, {'H', 'H', '1', '2'}, {'H', 'H'}, {'M', 'I'}, {'S', 'S'}, {'A', 'M'}, {'P', 'M'}, {'A', '.', 'M', '.'}, {'P', '.', 'M', '.'}, {'F', 'F'}};
        javaDateTokens = new String[]{"yyyy", "'*IYYY'", "yyyy", "'*IY'", "yy", "G", "G", "G", "G", "MMM", "MMMMM", "MM", "EEEE", "EE", "'*WW'", "w", "dd", "D", "'*W'", "HH", "KK", "KK", "mm", "ss", "aaa", "aaa", "aaa", "aaa", "S"};
        sqlIntervalCodes = new int[]{-1, -1, 101, -1, 101, -1, -1, -1, -1, 102, 102, 102, -1, -1, 262, -1, 103, 103, 104, -1, 104, 105, 106, -1, -1, -1, -1, -1};
    }

    static class Tokenizer {
        private int lastMatched;
        private int matchOffset;
        private int offset;
        private long state;
        private boolean consumed;
        private boolean isInQuotes;
        private boolean matched;
        private final char quoteChar = (char)34;
        private final char[] literalChars = defaultLiterals;
        private static char[] defaultLiterals = new char[]{' ', ',', '-', '.', '/', ':', ';'};
        char[][] tokens = HsqlDateTime.access$200();

        public Tokenizer() {
            this.reset();
        }

        public void reset() {
            this.lastMatched = -1;
            this.offset = -1;
            this.state = 0L;
            this.consumed = false;
            this.matched = false;
        }

        public int length() {
            return this.offset;
        }

        public int getLastMatch() {
            return this.lastMatched;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        public boolean wasMatched() {
            return this.matched;
        }

        public boolean isInQuotes() {
            return this.isInQuotes;
        }

        public boolean isQuoteChar(char c) {
            if (this.quoteChar == c) {
                this.isInQuotes = !this.isInQuotes;
                return true;
            }
            return false;
        }

        public boolean isLiteral(char c) {
            return ArrayUtil.isInSortedArray(c, this.literalChars);
        }

        private boolean isZeroBit(int n) {
            return (this.state & 1L << n) == 0L;
        }

        private void setBit(int n) {
            this.state |= 1L << n;
        }

        public boolean next(char c, int n) {
            int n2 = ++this.offset;
            int n3 = this.offset + 1;
            int n4 = 0;
            this.matched = false;
            int n5 = this.tokens.length;
            while (--n5 >= 0) {
                if (!this.isZeroBit(n5)) continue;
                if (this.tokens[n5][n2] == c) {
                    if (this.tokens[n5].length == n3) {
                        this.setBit(n5);
                        this.lastMatched = n5;
                        this.consumed = true;
                        this.matched = true;
                        this.matchOffset = n;
                        continue;
                    }
                    ++n4;
                    continue;
                }
                this.setBit(n5);
            }
            return n4 > 0;
        }
    }
}

