/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDML;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCompound;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementExpression;
import org.hsqldb.StatementHandler;
import org.hsqldb.StatementProcedure;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSet;
import org.hsqldb.StatementSimple;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.Type;

public class ParserRoutine
extends ParserDML {
    ParserRoutine(Session session, Scanner scanner) {
        super(session, scanner);
    }

    Expression readDefaultClause(Type type) {
        Expression expression = null;
        boolean bl = false;
        if (this.token.tokenType == 186) {
            this.read();
            return new ExpressionValue(null, type);
        }
        if (type.isDateTimeType() || type.isIntervalType()) {
            switch (this.token.tokenType) {
                case 72: 
                case 140: 
                case 281: 
                case 282: {
                    expression = this.readDateTimeIntervalLiteral();
                    if (expression.dataType.typeCode != type.typeCode) {
                        throw this.unexpectedToken();
                    }
                    Object object = expression.getValue(this.session, type);
                    return new ExpressionValue(object, type);
                }
                case 845: {
                    break;
                }
                default: {
                    expression = this.XreadDateTimeValueFunctionOrNull();
                    if (expression == null) break;
                    expression = this.XreadModifier(expression);
                    break;
                }
            }
        } else if (type.isNumberType()) {
            if (this.token.tokenType == 784) {
                this.read();
                bl = true;
            } else if (this.database.sqlSyntaxPgs && this.token.tokenType == 610) {
                return this.readNextvalFunction();
            }
        } else if (type.isCharacterType()) {
            switch (this.token.tokenType) {
                case 60: 
                case 63: 
                case 64: 
                case 65: 
                case 69: 
                case 253: 
                case 277: 
                case 305: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                    expression = this.readSQLFunction(functionSQL);
                    break;
                }
            }
        } else if (type.isBooleanType()) {
            switch (this.token.tokenType) {
                case 294: {
                    this.read();
                    return Expression.EXPR_TRUE;
                }
                case 106: {
                    this.read();
                    return Expression.EXPR_FALSE;
                }
            }
        } else if (type.isBitType()) {
            switch (this.token.tokenType) {
                case 294: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitOne, type);
                }
                case 106: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitZero, type);
                }
            }
        } else if (type.isArrayType()) {
            expression = this.readCollection(19);
            if (expression.nodes.length > 0) {
                throw Error.error(5562);
            }
            expression.dataType = type;
            return expression;
        }
        if (expression != null) {
            expression.resolveTypes(this.session, null);
            if (type.typeComparisonGroup != expression.getDataType().typeComparisonGroup) {
                throw Error.error(5562);
            }
            return expression;
        }
        boolean bl2 = false;
        if (this.database.sqlSyntaxMss && this.token.tokenType == 786) {
            this.read();
            bl2 = true;
        }
        if (this.token.tokenType == 845) {
            Object object = this.token.tokenValue;
            Type type2 = this.token.dataType;
            Type type3 = type;
            if (type.typeCode == 40) {
                type3 = Type.getType(12, null, this.database.collation, type.precision, 0);
            } else if (type.typeCode == 30) {
                type3 = Type.getType(61, null, null, type.precision, 0);
            }
            object = type3.convertToType(this.session, object, type2);
            this.read();
            if (bl) {
                object = type.negate(object);
            }
            if (bl2) {
                this.readThis(772);
            }
            return new ExpressionValue(object, type3);
        }
        throw this.unexpectedToken();
    }

    Statement compileOpenCursorStatement(StatementCompound statementCompound) {
        this.readThis(196);
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        this.read();
        for (int i = 0; i < statementCompound.cursors.length; ++i) {
            if (!statementCompound.cursors[i].getCursorName().name.equals(string)) continue;
            return statementCompound.cursors[i];
        }
        throw Error.error(4680);
    }

    Statement compileSelectSingleRowStatement(RangeVariable[] rangeVariableArray) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        QuerySpecification querySpecification = this.XreadSelect();
        LongDeque longDeque = new LongDeque();
        this.readThis(141);
        this.readTargetSpecificationList(orderedHashSet, rangeVariableArray, longDeque);
        this.XreadTableExpression(querySpecification);
        querySpecification.setReturningResult();
        int[] nArray = new int[longDeque.size()];
        longDeque.toArray(nArray);
        Object[] objectArray = new Expression[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        Type[] typeArray = new Type[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (((Expression)objectArray[i]).getColumn().getParameterMode() == 1) {
                throw Error.error(2500);
            }
            typeArray[i] = ((Expression)objectArray[i]).getDataType();
        }
        querySpecification.setReturningResult();
        querySpecification.resolve(this.session, rangeVariableArray, typeArray);
        if (querySpecification.getColumnCount() != objectArray.length) {
            throw Error.error(5564, "INTO");
        }
        StatementSet statementSet = new StatementSet(this.session, (Expression[])objectArray, querySpecification, nArray, this.compileContext);
        return statementSet;
    }

    Statement compileGetStatement(RangeVariable[] rangeVariableArray) {
        int n;
        this.read();
        this.readThis(391);
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        LongDeque longDeque = new LongDeque();
        this.readGetClauseList(rangeVariableArray, orderedHashSet, longDeque, hsqlArrayList);
        if (hsqlArrayList.size() > 1) {
            throw Error.error(5602);
        }
        Expression expression = (Expression)hsqlArrayList.get(0);
        if (expression.getDegree() != orderedHashSet.size()) {
            throw Error.error(5546, "SET");
        }
        int[] nArray = new int[longDeque.size()];
        longDeque.toArray(nArray);
        Object[] objectArray = new Expression[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            this.resolveOuterReferencesAndTypes(rangeVariableArray, (Expression)objectArray[n]);
        }
        this.resolveOuterReferencesAndTypes(rangeVariableArray, expression);
        for (n = 0; n < objectArray.length; ++n) {
            if (((Expression)objectArray[n]).getColumn().getParameterMode() == 1) {
                throw Error.error(2500);
            }
            if (((Expression)objectArray[n]).getDataType().canBeAssignedFrom(expression.getNodeDataType(n))) continue;
            throw Error.error(5561);
        }
        StatementSet statementSet = new StatementSet(this.session, (Expression[])objectArray, expression, nArray, this.compileContext);
        return statementSet;
    }

    Statement compileSetStatement(RangeVariable[] rangeVariableArray) {
        int n;
        this.read();
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        LongDeque longDeque = new LongDeque();
        this.readSetClauseList(rangeVariableArray, orderedHashSet, longDeque, hsqlArrayList);
        if (hsqlArrayList.size() > 1) {
            throw Error.error(5602);
        }
        Expression expression = (Expression)hsqlArrayList.get(0);
        if (expression.getDegree() != orderedHashSet.size()) {
            throw Error.error(5546, "SET");
        }
        int[] nArray = new int[longDeque.size()];
        longDeque.toArray(nArray);
        Object[] objectArray = new Expression[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            this.resolveOuterReferencesAndTypes(rangeVariableArray, (Expression)objectArray[n]);
        }
        this.resolveOuterReferencesAndTypes(rangeVariableArray, expression);
        for (n = 0; n < objectArray.length; ++n) {
            if (((Expression)objectArray[n]).getColumn().getParameterMode() == 1) {
                throw Error.error(2500);
            }
            if (((Expression)objectArray[n]).getDataType().canBeAssignedFrom(expression.getNodeDataType(n))) continue;
            throw Error.error(5561);
        }
        StatementSet statementSet = new StatementSet(this.session, (Expression[])objectArray, expression, nArray, this.compileContext);
        return statementSet;
    }

    StatementDMQL compileTriggerSetStatement(Table table, RangeVariable[] rangeVariableArray) {
        this.read();
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        RangeVariable[] rangeVariableArray2 = new RangeVariable[]{rangeVariableArray[1]};
        LongDeque longDeque = new LongDeque();
        this.readSetClauseList(rangeVariableArray2, orderedHashSet, longDeque, hsqlArrayList);
        int[] nArray = new int[longDeque.size()];
        longDeque.toArray(nArray);
        Object[] objectArray = new Expression[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.resolveOuterReferencesAndTypes(RangeVariable.emptyArray, (Expression)objectArray[i]);
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        this.resolveUpdateExpressions(table, rangeVariableArray, nArray, expressionArray, RangeVariable.emptyArray);
        StatementSet statementSet = new StatementSet(this.session, (Expression[])objectArray, table, rangeVariableArray, nArray, expressionArray, this.compileContext);
        return statementSet;
    }

    StatementSchema compileAlterSpecificRoutine() {
        Object[] objectArray;
        boolean bl = false;
        this.readThis(259);
        this.readThis(491);
        Routine routine = (Routine)this.readSchemaObjectName(24);
        routine = routine.duplicate();
        this.readRoutineCharacteristics(routine);
        bl = this.readIfThis(485);
        if (bl && !(objectArray = this.database.schemaManager.getReferencesTo(routine.getSpecificName())).isEmpty()) {
            throw Error.error(5502);
        }
        if (this.token.tokenType == 567) {
            this.read();
        } else if (this.token.tokenType == 445) {
            this.read();
        }
        this.readRoutineBody(routine);
        routine.resetAlteredRoutineSettings();
        routine.resolve(this.session);
        objectArray = new Object[]{routine};
        String string = this.getLastPart();
        StatementSchema statementSchema = new StatementSchema(string, 17, objectArray, null, this.database.schemaManager.getCatalogNameArray());
        return statementSchema;
    }

    StatementSchema compileCreateProcedureOrFunction() {
        Object[] objectArray;
        boolean bl = false;
        if (this.token.tokenType == 559) {
            bl = true;
            this.read();
            if (this.token.tokenType == 215) {
                throw super.unexpectedToken();
            }
        }
        int n = this.token.tokenType == 215 ? 17 : 16;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(n, true);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        Routine routine = new Routine(n);
        routine.setName(hsqlName);
        routine.setAggregate(bl);
        this.readThis(786);
        if (this.token.tokenType == 772) {
            this.read();
        } else {
            while (true) {
                objectArray = this.readRoutineParameter(routine, true);
                routine.addParameter((ColumnSchema)objectArray);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            this.readThis(772);
        }
        if (n != 17) {
            this.readThis(238);
            if (this.token.tokenType == 278) {
                this.read();
                objectArray = new TableDerived(this.database, SqlInvariants.MODULE_HSQLNAME, 11);
                this.readTableDefinition(routine, (Table)objectArray);
                routine.setReturnTable((TableDerived)objectArray);
            } else {
                objectArray = this.readTypeDefinition(false, true);
                routine.setReturnType((Type)objectArray);
            }
        }
        this.readRoutineCharacteristics(routine);
        this.readRoutineBody(routine);
        objectArray = new Object[]{routine};
        String string = this.getLastPart();
        StatementSchema statementSchema = new StatementSchema(string, 14, objectArray, null, this.database.schemaManager.getCatalogNameArray());
        return statementSchema;
    }

    Routine readCreatePasswordCheckFunction() {
        Routine routine = new Routine(16);
        if (this.token.tokenType == 181) {
            this.read();
            return null;
        }
        if (this.token.tokenType == 104) {
            routine.setLanguage(1);
            routine.setDataImpact(1);
        } else {
            routine.setLanguage(2);
            routine.setDataImpact(2);
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName("PASSWORD", false, 16);
        hsqlName.setSchemaIfNull(SqlInvariants.SYSTEM_SCHEMA_HSQLNAME);
        routine.setName(hsqlName);
        hsqlName = this.database.nameManager.newHsqlName("PASSWORD", false, 23);
        ColumnSchema columnSchema = new ColumnSchema(hsqlName, Type.SQL_VARCHAR, false, false, null);
        routine.addParameter(columnSchema);
        routine.setReturnType(Type.SQL_BOOLEAN);
        this.readRoutineBody(routine);
        routine.resolve(this.session);
        return routine;
    }

    Routine readCreateDatabaseAuthenticationFunction() {
        Routine routine = new Routine(16);
        if (this.token.tokenType == 181) {
            this.read();
            return null;
        }
        this.checkIsThis(104);
        routine.setLanguage(1);
        routine.setDataImpact(1);
        routine.setName(this.database.nameManager.newHsqlName("AUTHENTICATION", false, 16));
        for (int i = 0; i < 3; ++i) {
            ColumnSchema columnSchema = new ColumnSchema(null, Type.SQL_VARCHAR, false, false, null);
            routine.addParameter(columnSchema);
        }
        routine.setReturnType(new ArrayType(Type.SQL_VARCHAR_DEFAULT, 1024));
        this.readRoutineBody(routine);
        routine.resolve(this.session);
        return routine;
    }

    private void readTableDefinition(Routine routine, Table table) throws HsqlException {
        this.readThis(786);
        int n = 0;
        while (true) {
            ColumnSchema columnSchema;
            if ((columnSchema = this.readRoutineParameter(routine, false)).getName() == null) {
                throw super.unexpectedToken();
            }
            table.addColumn(columnSchema);
            if (this.token.tokenType != 774) break;
            this.read();
            ++n;
        }
        this.readThis(772);
        table.createPrimaryKey();
    }

    private void readRoutineCharacteristics(Routine routine) {
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        boolean bl = false;
        block16: while (!bl) {
            switch (this.token.tokenType) {
                case 146: {
                    if (!orderedIntHashSet.add(146)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 425) {
                        this.read();
                        routine.setLanguage(1);
                        continue block16;
                    }
                    if (this.token.tokenType == 261) {
                        this.read();
                        routine.setLanguage(2);
                        continue block16;
                    }
                    throw this.unexpectedToken();
                }
                case 204: {
                    if (!orderedIntHashSet.add(204)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(519);
                    if (this.token.tokenType == 425) {
                        this.read();
                        routine.setParameterStyle(1);
                        continue block16;
                    }
                    this.readThis(261);
                    routine.setParameterStyle(2);
                    continue block16;
                }
                case 259: {
                    if (!orderedIntHashSet.add(259)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(24, false);
                    routine.setSpecificName(hsqlName);
                    continue block16;
                }
                case 83: {
                    if (!orderedIntHashSet.add(83)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    routine.setDeterministic(true);
                    continue block16;
                }
                case 183: {
                    if (!orderedIntHashSet.add(83)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(83);
                    routine.setDeterministic(false);
                    continue block16;
                }
                case 171: {
                    if (!orderedIntHashSet.add(261)) {
                        throw this.unexpectedToken();
                    }
                    if (routine.getType() == 16) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(261);
                    this.readThis(378);
                    routine.setDataImpact(4);
                    continue block16;
                }
                case 180: {
                    if (!orderedIntHashSet.add(261)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(261);
                    routine.setDataImpact(1);
                    continue block16;
                }
                case 218: {
                    if (!orderedIntHashSet.add(261)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(261);
                    this.readThis(378);
                    routine.setDataImpact(3);
                    continue block16;
                }
                case 375: {
                    if (!orderedIntHashSet.add(261)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(261);
                    routine.setDataImpact(2);
                    continue block16;
                }
                case 238: {
                    if (!orderedIntHashSet.add(186) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    if (routine.isAggregate()) {
                        throw Error.error(5604, this.token.tokenString);
                    }
                    this.read();
                    this.readThis(186);
                    this.readThis(194);
                    this.readThis(186);
                    this.readThis(419);
                    routine.setNullInputOutput(true);
                    continue block16;
                }
                case 26: {
                    if (!orderedIntHashSet.add(186) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(194);
                    this.readThis(186);
                    this.readThis(419);
                    routine.setNullInputOutput(false);
                    continue block16;
                }
                case 89: {
                    if (!orderedIntHashSet.add(236) || routine.isFunction()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(236);
                    this.readThis(510);
                    int n = this.readInteger();
                    if (n < 0 || n > 16) {
                        throw Error.error(5604, String.valueOf(n));
                    }
                    routine.setMaxDynamicResults(n);
                    continue block16;
                }
                case 179: {
                    if (routine.getType() == 16 || !orderedIntHashSet.add(246)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(246);
                    this.readThis(432);
                    routine.setNewSavepointLevel(true);
                    continue block16;
                }
                case 193: {
                    if (routine.getType() == 16 || !orderedIntHashSet.add(246)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(246);
                    this.readThis(432);
                    routine.setNewSavepointLevel(false);
                    throw super.unsupportedFeature("OLD");
                }
            }
            bl = true;
        }
    }

    void readRoutineBody(Routine routine) {
        if (this.token.tokenType == 104) {
            if (routine.getLanguage() != 1) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(445);
            this.checkIsValue(1);
            routine.setMethodURL((String)this.token.tokenValue);
            this.read();
            if (this.token.tokenType == 204) {
                this.read();
                this.readThis(519);
                this.readThis(425);
            }
        } else {
            this.startRecording();
            Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
            if (statement == null) {
                throw this.unexpectedToken();
            }
            Token[] tokenArray = this.getRecordedStatement();
            String string = Token.getSQL(tokenArray);
            statement.setSQL(string);
            routine.setProcedure(statement);
        }
    }

    private Object[] readLocalDeclarationList(Routine routine, StatementCompound statementCompound) {
        Object object;
        RangeVariable[] rangeVariableArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        int n = 0;
        RangeVariable[] rangeVariableArray2 = rangeVariableArray = statementCompound == null ? routine.getParameterRangeVariables() : statementCompound.getRangeVariables();
        while (this.token.tokenType == 77) {
            object = null;
            if (n == 0) {
                object = this.readLocalTableVariableDeclarationOrNull(routine);
                if (object == null) {
                    n = 1;
                    continue;
                }
                hsqlArrayList.add(object);
                this.readThis(791);
                continue;
            }
            if (n == 1) {
                object = this.readLocalVariableDeclarationOrNull();
                if (object == null) {
                    n = 2;
                    continue;
                }
                hsqlArrayList.addAll((Object[])object);
                continue;
            }
            if (n == 2) {
                object = this.compileDeclareCursor(true, rangeVariableArray);
                if (object == null) {
                    n = 3;
                    continue;
                }
                hsqlArrayList.add(object);
                this.readThis(791);
                continue;
            }
            if (n != 3) continue;
            object = this.compileLocalHandlerDeclaration(routine, statementCompound);
            hsqlArrayList.add(object);
        }
        object = new Object[hsqlArrayList.size()];
        hsqlArrayList.toArray(object);
        return object;
    }

    Table readLocalTableVariableDeclarationOrNull(Routine routine) {
        int n = super.getPosition();
        this.readThis(77);
        if (this.token.tokenType == 278) {
            this.read();
            HsqlNameManager.HsqlName hsqlName = super.readNewSchemaObjectName(3, false);
            hsqlName.schema = SqlInvariants.MODULE_HSQLNAME;
            Table table = new Table(this.database, hsqlName, 11);
            this.readTableDefinition(routine, table);
            return table;
        }
        this.rewind(n);
        return null;
    }

    ColumnSchema[] readLocalVariableDeclarationOrNull() {
        Type type;
        int n = super.getPosition();
        HsqlNameManager.HsqlName[] hsqlNameArray = HsqlNameManager.HsqlName.emptyArray;
        try {
            this.readThis(77);
            if (this.isReservedKey()) {
                this.rewind(n);
                return null;
            }
            while (true) {
                hsqlNameArray = (HsqlNameManager.HsqlName[])ArrayUtil.resizeArray(hsqlNameArray, hsqlNameArray.length + 1);
                hsqlNameArray[hsqlNameArray.length - 1] = super.readNewSchemaObjectName(22, false);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            type = this.readTypeDefinition(false, true);
        }
        catch (HsqlException hsqlException) {
            this.rewind(n);
            return null;
        }
        Expression expression = null;
        if (this.token.tokenType == 78) {
            this.read();
            expression = this.readDefaultClause(type);
        }
        ColumnSchema[] columnSchemaArray = new ColumnSchema[hsqlNameArray.length];
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            columnSchemaArray[i] = new ColumnSchema(hsqlNameArray[i], type, true, false, expression);
            columnSchemaArray[i].setParameterMode((byte)2);
        }
        this.readThis(791);
        return columnSchemaArray;
    }

    private StatementHandler compileLocalHandlerDeclaration(Routine routine, StatementCompound statementCompound) {
        int n;
        this.readThis(77);
        switch (this.token.tokenType) {
            case 376: {
                this.read();
                n = 5;
                break;
            }
            case 102: {
                this.read();
                n = 6;
                break;
            }
            case 297: {
                this.read();
                n = 7;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(124);
        this.readThis(112);
        StatementHandler statementHandler = new StatementHandler(n);
        boolean bl = false;
        boolean bl2 = true;
        block12: while (!bl) {
            int n2 = 0;
            switch (this.token.tokenType) {
                case 774: {
                    if (bl2) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl2 = true;
                    continue block12;
                }
                case 263: {
                    n2 = 4;
                }
                case 262: {
                    if (n2 == 0) {
                        n2 = 1;
                    }
                }
                case 264: {
                    if (n2 == 0) {
                        n2 = 2;
                    }
                }
                case 183: {
                    if (n2 == 0) {
                        n2 = 3;
                    }
                    if (!bl2) {
                        throw this.unexpectedToken();
                    }
                    bl2 = false;
                    this.read();
                    if (n2 == 3) {
                        this.readThis(404);
                    } else if (n2 == 4) {
                        String string = this.parseSQLStateValue();
                        statementHandler.addConditionState(string);
                        continue block12;
                    }
                    statementHandler.addConditionType(n2);
                    continue block12;
                }
            }
            if (bl2) {
                throw this.unexpectedToken();
            }
            bl = true;
        }
        if (this.token.tokenType == 791) {
            this.read();
        } else {
            Statement statement = this.compileSQLProcedureStatementOrNull(routine, statementCompound);
            if (statement == null) {
                throw this.unexpectedToken();
            }
            this.readThis(791);
            statementHandler.addStatement(statement);
        }
        return statementHandler;
    }

    String parseSQLStateValue() {
        this.readIfThis(307);
        this.checkIsValue(1);
        String string = this.token.tokenString;
        if (this.token.tokenString.length() != 5) {
            throw Error.error(5607);
        }
        this.read();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement compileCompoundStatement(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(17);
        this.readThis(14);
        StatementCompound statementCompound2 = new StatementCompound(12, hsqlName);
        statementCompound2.setAtomic(true);
        statementCompound2.setRoot(routine);
        statementCompound2.setParent(statementCompound);
        Object[] objectArray = this.readLocalDeclarationList(routine, statementCompound);
        statementCompound2.setLocalDeclarations(objectArray);
        this.session.sessionContext.pushRoutineTables(statementCompound2.scopeTables);
        try {
            Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound2);
            statementCompound2.setStatements(statementArray);
        }
        finally {
            this.session.sessionContext.popRoutineTables();
        }
        this.readThis(94);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        return statementCompound2;
    }

    private Statement[] compileSQLProcedureStatementList(Routine routine, StatementCompound statementCompound) {
        Statement statement;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while ((statement = this.compileSQLProcedureStatementOrNull(routine, statementCompound)) != null) {
            this.readThis(791);
            hsqlArrayList.add(statement);
        }
        if (hsqlArrayList.size() == 0) {
            throw this.unexpectedToken();
        }
        Statement[] statementArray = new Statement[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementArray);
        return statementArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Statement compileSQLProcedureStatementOrNull(Routine routine, StatementCompound statementCompound) {
        RangeVariable[] rangeVariableArray;
        Statement statement = null;
        HsqlNameManager.HsqlName hsqlName = null;
        RangeVariable[] rangeVariableArray2 = rangeVariableArray = statementCompound == null ? routine.getParameterRangeVariables() : statementCompound.getRangeVariables();
        if (!routine.isTrigger() && this.isSimpleName() && !this.isReservedKey()) {
            hsqlName = this.readNewSchemaObjectName(21, false);
            if (this.token.tokenType != 773) {
                throw this.unexpectedToken(hsqlName.getNameString());
            }
            this.readThis(773);
        }
        this.compileContext.reset();
        HsqlNameManager.HsqlName hsqlName2 = this.session.getCurrentSchemaHsqlName();
        this.session.setCurrentSchemaHsqlName(routine.getSchemaName());
        try {
            switch (this.token.tokenType) {
                case 196: {
                    if (routine.dataImpact == 2) {
                        throw Error.error(5602, routine.getDataImpactString());
                    }
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileOpenCursorStatement(statementCompound);
                    break;
                }
                case 251: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileSelectSingleRowStatement(rangeVariableArray);
                    break;
                }
                case 135: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileInsertStatement(rangeVariableArray);
                    break;
                }
                case 303: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileUpdateStatement(rangeVariableArray);
                    break;
                }
                case 79: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileDeleteStatement(rangeVariableArray);
                    break;
                }
                case 295: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileTruncateStatement();
                    break;
                }
                case 166: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileMergeStatement(rangeVariableArray);
                    break;
                }
                case 254: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    if (routine.isTrigger()) {
                        if (routine.triggerOperation == 19) {
                            statement = this.compileSetStatement(rangeVariableArray);
                            break;
                        }
                        if (routine.triggerType != 4) {
                            statement = this.compileSetStatement(rangeVariableArray);
                            break;
                        }
                        int n = super.getPosition();
                        try {
                            statement = this.compileTriggerSetStatement(routine.triggerTable, rangeVariableArray);
                        }
                        catch (HsqlException hsqlException) {
                            this.rewind(n);
                            statement = this.compileSetStatement(rangeVariableArray);
                        }
                        break;
                    }
                    statement = this.compileSetStatement(rangeVariableArray);
                    break;
                }
                case 119: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileGetStatement(rangeVariableArray);
                    break;
                }
                case 25: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileCallStatement(rangeVariableArray, true);
                    Routine routine2 = ((StatementProcedure)statement).procedure;
                    if (routine2 == null) break;
                    switch (routine.dataImpact) {
                        case 2: {
                            if (routine2.dataImpact != 3 && routine2.dataImpact != 4) break;
                            throw Error.error(5602, routine.getDataImpactString());
                        }
                        case 3: {
                            if (routine2.dataImpact != 4) break;
                            throw Error.error(5602, routine.getDataImpactString());
                        }
                    }
                    break;
                }
                case 237: {
                    if (routine.isTrigger() || hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    statement = this.compileReturnValue(routine, statementCompound);
                    break;
                }
                case 17: {
                    statement = this.compileCompoundStatement(routine, statementCompound, hsqlName);
                    break;
                }
                case 322: {
                    if (routine.isTrigger()) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileWhile(routine, statementCompound, hsqlName);
                    break;
                }
                case 234: {
                    statement = this.compileRepeat(routine, statementCompound, hsqlName);
                    break;
                }
                case 160: {
                    statement = this.compileLoop(routine, statementCompound, hsqlName);
                    break;
                }
                case 112: {
                    statement = this.compileFor(routine, statementCompound, hsqlName);
                    break;
                }
                case 143: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileIterate();
                    break;
                }
                case 152: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileLeave(routine, statementCompound);
                    break;
                }
                case 412: {
                    statement = this.compileIf(routine, statementCompound);
                    break;
                }
                case 29: {
                    statement = this.compileCase(routine, statementCompound);
                    break;
                }
                case 255: {
                    statement = this.compileSignal(routine, statementCompound, hsqlName);
                    break;
                }
                case 235: {
                    statement = this.compileResignal(routine, statementCompound, hsqlName);
                    break;
                }
                default: {
                    Statement statement2 = null;
                    return statement2;
                }
            }
            statement.setRoot(routine);
            statement.setParent(statementCompound);
            Statement statement3 = statement;
            return statement3;
        }
        finally {
            this.session.setCurrentSchemaHsqlName(hsqlName2);
        }
    }

    private Statement compileReturnValue(Routine routine, StatementCompound statementCompound) {
        Expression expression = this.XreadValueExpressionOrNull();
        if (expression == null) {
            this.checkIsValue();
            if (this.token.tokenValue == null) {
                expression = new ExpressionValue(null, null);
            }
        }
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        if (routine.isProcedure()) {
            throw Error.error(5602);
        }
        return new StatementExpression(this.session, this.compileContext, 58, expression);
    }

    private Statement compileIterate() {
        this.readThis(143);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(102, hsqlName);
    }

    private Statement compileLeave(Routine routine, StatementCompound statementCompound) {
        this.readThis(152);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(89, hsqlName);
    }

    private Statement compileWhile(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(322);
        Expression expression = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1201, expression);
        this.readThis(86);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        this.readThis(94);
        this.readThis(322);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statementCompound2 = new StatementCompound(97, hsqlName);
        statementCompound2.setStatements(statementArray);
        statementCompound2.setCondition(statementExpression);
        return statementCompound2;
    }

    private Statement compileRepeat(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(234);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        this.readThis(302);
        Expression expression = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1201, expression);
        this.readThis(94);
        this.readThis(234);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statementCompound2 = new StatementCompound(95, hsqlName);
        statementCompound2.setStatements(statementArray);
        statementCompound2.setCondition(statementExpression);
        return statementCompound2;
    }

    private Statement compileLoop(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(160);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        this.readThis(94);
        this.readThis(160);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statementCompound2 = new StatementCompound(90, hsqlName);
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    private Statement compileFor(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        RangeVariable[] rangeVariableArray = statementCompound == null ? routine.getParameterRangeVariables() : statementCompound.getRangeVariables();
        this.readThis(112);
        StatementQuery statementQuery = this.compileCursorSpecification(0, false, rangeVariableArray);
        this.readThis(86);
        StatementCompound statementCompound2 = new StatementCompound(46, hsqlName);
        statementCompound2.setAtomic(true);
        statementCompound2.setRoot(routine);
        statementCompound2.setParent(statementCompound);
        statementCompound2.setLoopStatement(statementQuery);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound2);
        this.readThis(94);
        this.readThis(112);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    private Statement compileIf(Routine routine, StatementCompound statementCompound) {
        int n;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.readThis(412);
        Expression expression = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1201, expression);
        hsqlArrayList.add(statementExpression);
        this.readThis(280);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        for (n = 0; n < statementArray.length; ++n) {
            hsqlArrayList.add(statementArray[n]);
        }
        while (this.token.tokenType == 93) {
            this.read();
            expression = this.XreadBooleanValueExpression();
            this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
            statementExpression = new StatementExpression(this.session, this.compileContext, 1201, expression);
            hsqlArrayList.add(statementExpression);
            this.readThis(280);
            statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (n = 0; n < statementArray.length; ++n) {
                hsqlArrayList.add(statementArray[n]);
            }
        }
        if (this.token.tokenType == 92) {
            this.read();
            expression = Expression.EXPR_TRUE;
            statementExpression = new StatementExpression(this.session, this.compileContext, 1201, expression);
            hsqlArrayList.add(statementExpression);
            statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (n = 0; n < statementArray.length; ++n) {
                hsqlArrayList.add(statementArray[n]);
            }
        }
        this.readThis(94);
        this.readThis(412);
        statementArray = new Statement[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementArray);
        StatementCompound statementCompound2 = new StatementCompound(88, null);
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    private Statement compileCase(Routine routine, StatementCompound statementCompound) {
        Statement[] statementArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Expression expression = null;
        this.readThis(29);
        hsqlArrayList = this.token.tokenType == 314 ? this.readCaseWhen(routine, statementCompound) : this.readSimpleCaseWhen(routine, statementCompound);
        if (this.token.tokenType == 92) {
            this.read();
            expression = Expression.EXPR_TRUE;
            StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1201, expression);
            hsqlArrayList.add(statementExpression);
            statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (int i = 0; i < statementArray.length; ++i) {
                hsqlArrayList.add(statementArray[i]);
            }
        }
        this.readThis(94);
        this.readThis(29);
        statementArray = new Statement[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementArray);
        StatementCompound statementCompound2 = new StatementCompound(88, null);
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    private HsqlArrayList readSimpleCaseWhen(Routine routine, StatementCompound statementCompound) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Expression expression = null;
        Expression expression2 = this.XreadRowValuePredicand();
        do {
            this.readThis(314);
            while (true) {
                Expression expression3;
                if (expression2 == (expression3 = this.XreadPredicateRightPart(expression2))) {
                    expression3 = new ExpressionLogical(expression2, this.XreadRowValuePredicand());
                }
                this.resolveOuterReferencesAndTypes(routine, statementCompound, expression3);
                expression = expression == null ? expression3 : new ExpressionLogical(50, expression, expression3);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1201, expression);
            hsqlArrayList.add(statementExpression);
            this.readThis(280);
            Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (int i = 0; i < statementArray.length; ++i) {
                hsqlArrayList.add(statementArray[i]);
            }
        } while (this.token.tokenType == 314);
        return hsqlArrayList;
    }

    private HsqlArrayList readCaseWhen(Routine routine, StatementCompound statementCompound) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Expression expression = null;
        do {
            this.readThis(314);
            expression = this.XreadBooleanValueExpression();
            this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
            StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1201, expression);
            hsqlArrayList.add(statementExpression);
            this.readThis(280);
            Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (int i = 0; i < statementArray.length; ++i) {
                hsqlArrayList.add(statementArray[i]);
            }
        } while (this.token.tokenType == 314);
        return hsqlArrayList;
    }

    private Statement compileSignal(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(255);
        this.readThis(263);
        String string = this.parseSQLStateValue();
        StatementSimple statementSimple = new StatementSimple(92, string);
        return statementSimple;
    }

    private Statement compileResignal(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        String string = null;
        this.readThis(235);
        if (this.readIfThis(263)) {
            string = this.parseSQLStateValue();
        }
        StatementSimple statementSimple = new StatementSimple(91, string);
        return statementSimple;
    }

    private ColumnSchema readRoutineParameter(Routine routine, boolean bl) {
        HsqlNameManager.HsqlName hsqlName = null;
        byte by = 1;
        if (bl) {
            switch (this.token.tokenType) {
                case 130: {
                    this.read();
                    break;
                }
                case 199: {
                    if (routine.getType() != 17) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    by = 4;
                    break;
                }
                case 133: {
                    if (routine.getType() != 17 && !routine.isAggregate()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    by = 2;
                    break;
                }
            }
        }
        if (!this.isReservedKey()) {
            hsqlName = this.readNewDependentSchemaObjectName(routine.getName(), 23);
        }
        Type type = this.readTypeDefinition(false, true);
        ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, true, false, null);
        if (bl) {
            columnSchema.setParameterMode(by);
        }
        return columnSchema;
    }

    void resolveOuterReferencesAndTypes(Routine routine, StatementCompound statementCompound, Expression expression) {
        RangeVariable[] rangeVariableArray = routine.getParameterRangeVariables();
        if (statementCompound != null) {
            rangeVariableArray = statementCompound.getRangeVariables();
        }
        this.resolveOuterReferencesAndTypes(rangeVariableArray, expression);
    }
}

