/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.Type;

public class TableBase {
    public static final int INFO_SCHEMA_TABLE = 1;
    public static final int SYSTEM_SUBQUERY = 2;
    public static final int TEMP_TABLE = 3;
    public static final int MEMORY_TABLE = 4;
    public static final int CACHED_TABLE = 5;
    public static final int TEMP_TEXT_TABLE = 6;
    public static final int TEXT_TABLE = 7;
    public static final int VIEW_TABLE = 8;
    public static final int RESULT_TABLE = 9;
    public static final int TRANSITION_TABLE = 10;
    public static final int FUNCTION_TABLE = 11;
    public static final int SYSTEM_TABLE = 12;
    public static final int SCOPE_STATEMENT = 21;
    public static final int SCOPE_TRANSACTION = 22;
    public static final int SCOPE_SESSION = 23;
    public static final int SCOPE_FULL = 24;
    public PersistentStore store;
    public int persistenceScope;
    public long persistenceId;
    int[] primaryKeyCols;
    Type[] primaryKeyTypes;
    int[] primaryKeyColsSequence;
    Index[] indexList;
    public Database database;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    Index bestIndex;
    Index fullIndex;
    boolean[] colNotNull;
    Type[] colTypes;
    protected int columnCount;
    int tableType;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected boolean isText;
    boolean isView;
    protected boolean isWithDataSource;
    public boolean isSessionBased;
    protected boolean isSchemaBased;
    protected boolean isLogged;
    private boolean isTransactional = true;
    boolean hasLobColumn;

    TableBase() {
    }

    public TableBase(Session session, Database database, int n, int n2, Type[] typeArray) {
        this.tableType = n2;
        this.persistenceScope = n;
        this.isSessionBased = true;
        this.persistenceId = database.persistentStoreCollection.getNextId();
        this.database = database;
        this.colTypes = typeArray;
        this.columnCount = typeArray.length;
        this.primaryKeyCols = new int[0];
        this.primaryKeyTypes = new Type[0];
        this.indexList = new Index[0];
        this.createPrimaryIndex(this.primaryKeyCols, this.primaryKeyTypes, null);
    }

    public TableBase duplicate() {
        TableBase tableBase = new TableBase();
        tableBase.tableType = this.tableType;
        tableBase.persistenceScope = this.persistenceScope;
        tableBase.isSessionBased = this.isSessionBased;
        tableBase.persistenceId = this.database.persistentStoreCollection.getNextId();
        tableBase.database = this.database;
        tableBase.colTypes = this.colTypes;
        tableBase.columnCount = this.colTypes.length;
        tableBase.primaryKeyCols = this.primaryKeyCols;
        tableBase.primaryKeyTypes = this.primaryKeyTypes;
        tableBase.indexList = this.indexList;
        return tableBase;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public long getPersistenceId() {
        return this.persistenceId;
    }

    int getId() {
        return 0;
    }

    public final boolean onCommitPreserve() {
        return this.persistenceScope == 23;
    }

    public final RowIterator rowIterator(Session session) {
        PersistentStore persistentStore = this.getRowStore(session);
        return this.getPrimaryIndex().firstRow(session, persistentStore);
    }

    public final RowIterator rowIterator(PersistentStore persistentStore) {
        return this.getPrimaryIndex().firstRow(persistentStore);
    }

    public final int getIndexCount() {
        return this.indexList.length;
    }

    public final Index getPrimaryIndex() {
        return this.indexList.length > 0 ? this.indexList[0] : null;
    }

    public final Type[] getPrimaryKeyTypes() {
        return this.primaryKeyTypes;
    }

    public final boolean hasPrimaryKey() {
        return this.primaryKeyCols.length != 0;
    }

    public final int[] getPrimaryKey() {
        return this.primaryKeyCols;
    }

    public final Type[] getColumnTypes() {
        return this.colTypes;
    }

    public Index getFullIndex() {
        return this.fullIndex;
    }

    public final Index getIndex(int n) {
        return this.indexList[n];
    }

    public final Index[] getIndexList() {
        return this.indexList;
    }

    public final boolean[] getNewColumnCheckList() {
        return new boolean[this.getColumnCount()];
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public final int getDataColumnCount() {
        return this.colTypes.length;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void setTransactional(boolean bl) {
        this.isTransactional = bl;
    }

    public final void setBestRowIdentifiers() {
        int[] nArray = null;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        if (this.colNotNull == null) {
            return;
        }
        this.bestIndex = null;
        this.bestIndexForColumn = new int[this.colTypes.length];
        ArrayUtil.fillArray(this.bestIndexForColumn, -1);
        for (int i = 0; i < this.indexList.length; ++i) {
            Index index = this.indexList[i];
            int[] nArray2 = index.getColumns();
            int n3 = index.getVisibleColumns();
            if (n3 == 0) continue;
            if (i == 0) {
                bl = true;
            }
            if (this.bestIndexForColumn[nArray2[0]] == -1) {
                this.bestIndexForColumn[nArray2[0]] = i;
            } else {
                Index index2 = this.indexList[this.bestIndexForColumn[nArray2[0]]];
                if (n3 > index2.getColumns().length) {
                    this.bestIndexForColumn[nArray2[0]] = i;
                }
            }
            if (!index.isUnique()) {
                if (this.bestIndex != null) continue;
                this.bestIndex = index;
                continue;
            }
            int n4 = 0;
            for (int j = 0; j < n3; ++j) {
                if (!this.colNotNull[nArray2[j]]) continue;
                ++n4;
            }
            if (this.bestIndex != null) {
                this.bestIndex = index;
            }
            if (n4 == n3) {
                if (nArray != null && n == n2 && n3 >= n) continue;
                nArray = nArray2;
                n = n3;
                n2 = n3;
                bl = true;
                continue;
            }
            if (bl || nArray != null && n3 >= n && n4 <= n2) continue;
            nArray = nArray2;
            n = n3;
            n2 = n4;
        }
        this.bestRowIdentifierCols = nArray == null || n == nArray.length ? nArray : ArrayUtil.arraySlice(nArray, 0, n);
        this.bestRowIdentifierStrict = bl;
        if (this.indexList[0].getColumnCount() > 0) {
            this.bestIndex = this.indexList[0];
        }
    }

    public final void createPrimaryIndex(int[] nArray, Type[] typeArray, HsqlNameManager.HsqlName hsqlName) {
        long l = this.database.persistentStoreCollection.getNextId();
        Index index = this.database.logger.newIndex(hsqlName, l, this, nArray, null, null, typeArray, true, nArray.length > 0, nArray.length > 0, false);
        try {
            this.addIndex(null, index);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public final Index createAndAddIndexStructure(Session session, HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean[] blArray, boolean[] blArray2, boolean bl, boolean bl2, boolean bl3) {
        Index index = this.createIndexStructure(hsqlName, nArray, blArray, blArray2, bl, bl2, bl3);
        this.addIndex(session, index);
        return index;
    }

    final Index createIndexStructure(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean[] blArray, boolean[] blArray2, boolean bl, boolean bl2, boolean bl3) {
        if (this.primaryKeyCols == null) {
            throw Error.runtimeError(201, "createIndex");
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        Type[] typeArray = new Type[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
            typeArray[i] = this.colTypes[nArray2[i]];
        }
        long l = this.database.persistentStoreCollection.getNextId();
        Index index = this.database.logger.newIndex(hsqlName, l, this, nArray2, blArray, blArray2, typeArray, false, bl, bl2, bl3);
        return index;
    }

    public void dropIndex(int n) {
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n, -1);
        for (int i = 0; i < this.indexList.length; ++i) {
            this.indexList[i].setPosition(i);
        }
        this.setBestRowIdentifiers();
        if (this.store != null) {
            this.store.resetAccessorKeys(this.indexList);
        }
    }

    final void addIndex(Session session, Index index) {
        int n;
        for (n = 0; n < this.indexList.length; ++n) {
            Index index2 = this.indexList[n];
            int n2 = index.getIndexOrderValue() - index2.getIndexOrderValue();
            if (n2 < 0) break;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, index, n, 1);
        for (n = 0; n < this.indexList.length; ++n) {
            this.indexList[n].setPosition(n);
        }
        if (this.store != null) {
            try {
                this.store.resetAccessorKeys(this.indexList);
            }
            catch (HsqlException hsqlException) {
                this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, index.getPosition(), -1);
                for (n = 0; n < this.indexList.length; ++n) {
                    this.indexList[n].setPosition(n);
                }
                throw hsqlException;
            }
        }
        this.setBestRowIdentifiers();
    }

    final void removeIndex(int n) {
        this.setBestRowIdentifiers();
    }

    public final void setIndexes(Index[] indexArray) {
        this.indexList = indexArray;
    }

    public final Object[] getEmptyRowData() {
        return new Object[this.getDataColumnCount()];
    }

    public final Index createIndex(Session session, HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean[] blArray, boolean[] blArray2, boolean bl, boolean bl2, boolean bl3) {
        Index index = this.createAndAddIndexStructure(session, hsqlName, nArray, blArray, blArray2, bl, bl2, bl3);
        return index;
    }

    public void clearAllData(Session session) {
        PersistentStore persistentStore = this.getRowStore(session);
        persistentStore.removeAll();
    }

    public void clearAllData(PersistentStore persistentStore) {
        persistentStore.removeAll();
    }

    public final boolean isEmpty(Session session) {
        if (this.getIndexCount() == 0) {
            return true;
        }
        PersistentStore persistentStore = this.getRowStore(session);
        return this.getIndex(0).isEmpty(persistentStore);
    }

    public PersistentStore getRowStore(Session session) {
        return this.store == null ? session.sessionData.persistentStoreCollection.getStore(this) : this.store;
    }
}

