/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public interface TransactionManager {
    public static final int LOCKS = 0;
    public static final int MVLOCKS = 1;
    public static final int MVCC = 2;
    public static final int ACTION_READ = 0;
    public static final int ACTION_DUP = 1;
    public static final int ACTION_REF = 2;

    public long getGlobalChangeTimestamp();

    public RowAction addDeleteAction(Session var1, Table var2, Row var3, int[] var4);

    public void addInsertAction(Session var1, Table var2, PersistentStore var3, Row var4, int[] var5);

    public void beginAction(Session var1, Statement var2);

    public void beginActionResume(Session var1);

    public void beginTransaction(Session var1);

    public boolean canRead(Session var1, Row var2, int var3, int[] var4);

    public boolean canRead(Session var1, int var2, int var3);

    public boolean commitTransaction(Session var1);

    public void completeActions(Session var1);

    public void convertTransactionIDs(IntLookup var1);

    public DoubleIntIndex getTransactionIDList();

    public int getTransactionControl();

    public boolean isMVRows();

    public boolean isMVCC();

    public boolean prepareCommitActions(Session var1);

    public void rollback(Session var1);

    public void rollbackAction(Session var1);

    public void rollbackSavepoint(Session var1, int var2);

    public void setTransactionControl(Session var1, int var2);

    public void setTransactionInfo(CachedObject var1);

    public void removeTransactionInfo(CachedObject var1);
}

