/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.MicroLayout;
import com.jgoodies.looks.MicroLayoutPolicies;
import com.jgoodies.looks.MicroLayoutPolicy;
import com.jgoodies.looks.common.MinimumSizedIcon;
import com.jgoodies.looks.common.RGBGrayFilter;
import com.jgoodies.looks.common.ShadowPopupFactory;
import com.jgoodies.looks.windows.WindowsBorders;
import com.jgoodies.looks.windows.WindowsIconFactory;
import java.awt.Color;
import java.awt.Insets;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;

public class WindowsLookAndFeel
extends com.sun.java.swing.plaf.windows.WindowsLookAndFeel {
    public static final String BORDER_STYLE_KEY = "jgoodies.windows.borderStyle";

    public String getName() {
        return "JGoodies Windows";
    }

    public String getDescription() {
        return "The JGoodies Windows Look and Feel - \u00a9 2001-2010 JGoodies Karsten Lentzsch";
    }

    public static FontPolicy getFontPolicy() {
        FontPolicy policy = (FontPolicy)UIManager.get("Windows.fontPolicy");
        if (policy != null) {
            return policy;
        }
        FontPolicy defaultPolicy = FontPolicies.getDefaultWindowsPolicy();
        return FontPolicies.customSettingsPolicy(defaultPolicy);
    }

    public static void setFontPolicy(FontPolicy fontPolicy) {
        UIManager.put("Windows.fontPolicy", fontPolicy);
    }

    public static MicroLayoutPolicy getMicroLayoutPolicy() {
        MicroLayoutPolicy policy = (MicroLayoutPolicy)UIManager.get("Windows.MicroLayoutPolicy");
        return policy != null ? policy : MicroLayoutPolicies.getDefaultWindowsPolicy();
    }

    public static void setMicroLayoutPolicy(MicroLayout microLayoutPolicy) {
        UIManager.put("Windows.MicroLayoutPolicy", microLayoutPolicy);
    }

    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
    }

    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
    }

    public Icon getDisabledIcon(JComponent component, Icon icon) {
        Icon disabledIcon = RGBGrayFilter.getDisabledIcon(component, icon);
        return disabledIcon != null ? new IconUIResource(disabledIcon) : null;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String windowsPrefix = "com.jgoodies.looks.windows.Windows";
        String commonPrefix = "com.jgoodies.looks.common.ExtBasic";
        Object[] uiDefaults = new Object[]{"ComboBoxUI", "com.jgoodies.looks.windows.WindowsComboBoxUI", "ButtonUI", "com.jgoodies.looks.windows.WindowsButtonUI", "ScrollPaneUI", "com.jgoodies.looks.windows.WindowsScrollPaneUI", "MenuBarUI", "com.jgoodies.looks.windows.WindowsMenuBarUI", "PopupMenuUI", "com.jgoodies.looks.windows.WindowsPopupMenuUI", "OptionPaneUI", "com.jgoodies.looks.windows.WindowsOptionPaneUI", "SplitPaneUI", "com.jgoodies.looks.windows.WindowsSplitPaneUI", "TabbedPaneUI", "com.jgoodies.looks.windows.WindowsTabbedPaneUI", "TextFieldUI", "com.jgoodies.looks.windows.WindowsTextFieldUI", "FormattedTextFieldUI", "com.jgoodies.looks.windows.WindowsFormattedTextFieldUI", "PasswordFieldUI", "com.jgoodies.looks.windows.WindowsPasswordFieldUI", "TextAreaUI", "com.jgoodies.looks.windows.WindowsTextAreaUI", "TreeUI", "com.jgoodies.looks.windows.WindowsTreeUI", "SeparatorUI", "com.jgoodies.looks.windows.WindowsSeparatorUI", "SpinnerUI", "com.jgoodies.looks.windows.WindowsSpinnerUI"};
        if (!LookUtils.IS_OS_WINDOWS_6_OR_LATER || !LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "MenuItemUI", "com.jgoodies.looks.windows.WindowsMenuItemUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "CheckBoxMenuItemUI", "com.jgoodies.looks.common.ExtBasicCheckBoxMenuItemUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "RadioButtonMenuItemUI", "com.jgoodies.looks.common.ExtBasicRadioButtonMenuItemUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "PopupMenuSeparatorUI", "com.jgoodies.looks.common.ExtBasicPopupMenuSeparatorUI");
        }
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            if (!LookUtils.IS_OS_WINDOWS_6_OR_LATER) {
                uiDefaults = WindowsLookAndFeel.append(uiDefaults, "MenuUI", "com.jgoodies.looks.windows.WindowsXPMenuUI");
            }
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ToolBarUI", "com.jgoodies.looks.windows.WindowsXPToolBarUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "TableHeaderUI", "com.jgoodies.looks.windows.WindowsXPTableHeaderUI");
        } else {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "MenuUI", "com.jgoodies.looks.common.ExtBasicMenuUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ToolBarUI", "com.jgoodies.looks.windows.WindowsToolBarUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ScrollBarUI", "com.jgoodies.looks.windows.WindowsScrollBarUI");
        }
        table.putDefaults(uiDefaults);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        boolean isXP = LookUtils.IS_LAF_WINDOWS_XP_ENABLED;
        boolean isClassic = !isXP;
        boolean isVista = LookUtils.IS_OS_WINDOWS_6_OR_LATER;
        this.initFontDefaults(table);
        if (isClassic) {
            this.initComponentDefaultsClassic(table);
        }
        MicroLayout microLayout = WindowsLookAndFeel.getMicroLayoutPolicy().getMicroLayout("Windows", table);
        if (!(isVista && LookUtils.IS_JAVA_6_OR_LATER && LookUtils.IS_LAF_WINDOWS_XP_ENABLED)) {
            this.initMenuItemDefaults(table, microLayout);
        }
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        InsetsUIResource checkBoxMargin = microLayout.getCheckBoxMargin();
        UIDefaults.ProxyLazyValue etchedBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource", "getEtchedBorderUIResource");
        SimpleProxyLazyValue buttonBorder = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getButtonBorder");
        Border menuBorder = isXP ? WindowsBorders.getXPMenuBorder() : WindowsBorders.getMenuBorder();
        BasicBorders.MarginBorder menuBarEmptyBorder = marginBorder;
        Border menuBarSeparatorBorder = WindowsBorders.getSeparatorBorder();
        Border menuBarEtchedBorder = WindowsBorders.getEtchedBorder();
        Border menuBarHeaderBorder = WindowsBorders.getMenuBarHeaderBorder();
        BasicBorders.MarginBorder toolBarEmptyBorder = marginBorder;
        Border toolBarSeparatorBorder = WindowsBorders.getSeparatorBorder();
        Border toolBarEtchedBorder = WindowsBorders.getEtchedBorder();
        Border toolBarHeaderBorder = WindowsBorders.getToolBarHeaderBorder();
        InsetsUIResource buttonMargin = microLayout.getButtonMargin();
        Object toolBarSeparatorSize = null;
        InsetsUIResource textInsets = microLayout.getTextInsets();
        InsetsUIResource wrappedTextInsets = microLayout.getWrappedTextInsets();
        InsetsUIResource comboEditorInsets = microLayout.getComboBoxEditorInsets();
        int comboBorderSize = microLayout.getComboBorderSize();
        int comboPopupBorderSize = microLayout.getComboPopupBorderSize();
        int comboRendererGap = comboEditorInsets.left + comboBorderSize - comboPopupBorderSize;
        EmptyBorder comboRendererBorder = new EmptyBorder(1, comboRendererGap, 1, comboRendererGap);
        Insets comboTableEditorInsets = new Insets(0, 0, 0, 0);
        InsetsUIResource popupMenuSeparatorMargin = microLayout.getPopupMenuSeparatorMargin();
        int treeFontSize = table.getFont("Tree.font").getSize();
        Integer rowHeight = new Integer(treeFontSize + 6);
        Color controlColor = table.getColor("control");
        Color disabledTextBackground = table.getColor("TextField.disabledBackground");
        Color inactiveTextBackground = table.getColor("TextField.inactiveBackground");
        Color comboBoxDisabledBackground = isVista && isXP ? table.getColor("ComboBox.background") : disabledTextBackground;
        Object menuBarBackground = isXP ? table.get("control") : table.get("menu");
        Object menuSelectionBackground = isXP ? table.get("MenuItem.selectionBackground") : table.get("Menu.background");
        Object menuSelectionForeground = isXP ? table.get("MenuItem.selectionForeground") : table.get("Menu.foreground");
        Character passwordEchoChar = new Character(isXP ? (char)'\u25cf' : '*');
        Object[] defaults = new Object[]{"Button.border", buttonBorder, "Button.margin", buttonMargin, "CheckBox.border", marginBorder, "CheckBox.margin", checkBoxMargin, "ComboBox.disabledBackground", comboBoxDisabledBackground, "ComboBox.editorBorder", marginBorder, "ComboBox.editorColumns", new Integer(5), "ComboBox.editorInsets", comboEditorInsets, "ComboBox.tableEditorInsets", comboTableEditorInsets, "ComboBox.rendererBorder", comboRendererBorder, "EditorPane.margin", wrappedTextInsets, "Menu.border", menuBorder, "Menu.borderPainted", Boolean.TRUE, "Menu.background", menuBarBackground, "Menu.selectionForeground", menuSelectionForeground, "Menu.selectionBackground", menuSelectionBackground, "MenuBar.background", menuBarBackground, "MenuBar.border", menuBarSeparatorBorder, "MenuBar.emptyBorder", menuBarEmptyBorder, "MenuBar.separatorBorder", menuBarSeparatorBorder, "MenuBar.etchedBorder", menuBarEtchedBorder, "MenuBar.headerBorder", menuBarHeaderBorder, "FormattedTextField.disabledBackground", disabledTextBackground, "FormattedTextField.inactiveBackground", inactiveTextBackground, "FormattedTextField.margin", textInsets, "PasswordField.margin", textInsets, "PasswordField.echoChar", passwordEchoChar, "PopupMenu.border", WindowsBorders.getPopupMenuBorder(), "PopupMenu.noMarginBorder", WindowsBorders.getNoMarginPopupMenuBorder(), "PopupMenuSeparator.margin", popupMenuSeparatorMargin, "ScrollPane.etchedBorder", etchedBorder, "Spinner.defaultEditorInsets", textInsets, "RadioButton.border", marginBorder, "RadioButton.margin", checkBoxMargin, "Table.gridColor", controlColor, "TextArea.margin", wrappedTextInsets, "TextArea.disabledBackground", disabledTextBackground, "TextArea.inactiveBackground", inactiveTextBackground, "TextField.margin", textInsets, "ToggleButton.margin", buttonMargin, "ToolBar.emptyBorder", toolBarEmptyBorder, "ToolBar.separatorBorder", toolBarSeparatorBorder, "ToolBar.etchedBorder", toolBarEtchedBorder, "ToolBar.headerBorder", toolBarHeaderBorder, "ToolBar.separatorSize", toolBarSeparatorSize, "ToolBar.margin", new InsetsUIResource(0, 10, 0, 0), "Tree.selectionBorderColor", controlColor, "Tree.rowHeight", rowHeight};
        if (LookUtils.IS_JAVA_5) {
            defaults = WindowsLookAndFeel.append(defaults, new Object[]{"Tree.openIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/TreeOpen.png") : WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/TreeOpen.gif"), "Tree.closedIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/TreeClosed.png") : WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/TreeClosed.gif")});
        }
        if (LookUtils.IS_JAVA_6_OR_LATER) {
            defaults = WindowsLookAndFeel.append(defaults, new Object[]{"Spinner.border", table.get("TextField.border")});
        }
        table.putDefaults(defaults);
    }

    private void initComponentDefaultsClassic(UIDefaults table) {
        SimpleProxyLazyValue checkBoxIcon = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getCheckBoxIcon");
        SimpleProxyLazyValue radioButtonIcon = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getRadioButtonIcon");
        BasicBorders.FieldBorder winInsetBorder = new BasicBorders.FieldBorder(table.getColor("controlShadow"), table.getColor("controlDkShadow"), table.getColor("controlHighlight"), table.getColor("controlLtHighlight"));
        Object[] defaults = new Object[]{"CheckBox.checkColor", table.get("controlText"), "CheckBox.icon", checkBoxIcon, "RadioButton.checkColor", table.get("controlText"), "RadioButton.icon", radioButtonIcon, "Table.scrollPaneBorder", winInsetBorder};
        table.putDefaults(defaults);
    }

    private void initFontDefaults(UIDefaults table) {
        FontPolicy fontChoicePolicy = WindowsLookAndFeel.getFontPolicy();
        FontSet fontSet = fontChoicePolicy.getFontSet("Windows", table);
        WindowsLookAndFeel.initFontDefaults(table, fontSet);
    }

    private void initMenuItemDefaults(UIDefaults table, MicroLayout microLayout) {
        InsetsUIResource menuMargin = microLayout.getMenuMargin();
        InsetsUIResource menuItemMargin = microLayout.getMenuItemMargin();
        MinimumSizedIcon menuItemCheckIcon = new MinimumSizedIcon();
        Object[] defaults = new Object[]{"Menu.margin", menuMargin, "MenuItem.borderPainted", Boolean.TRUE, "MenuItem.checkIcon", menuItemCheckIcon, "MenuItem.margin", menuItemMargin, "CheckBoxMenuItem.margin", menuItemMargin, "RadioButtonMenuItem.margin", menuItemMargin};
        table.putDefaults(defaults);
    }

    private static void initFontDefaults(UIDefaults table, FontSet fontSet) {
        FontUIResource controlFont = fontSet.getControlFont();
        FontUIResource menuFont = fontSet.getMenuFont();
        FontUIResource messageFont = fontSet.getMessageFont();
        FontUIResource toolTipFont = fontSet.getSmallFont();
        FontUIResource titleFont = fontSet.getTitleFont();
        FontUIResource windowFont = fontSet.getWindowTitleFont();
        Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextArea.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "TitledBorder.font", titleFont, "ToolTip.font", toolTipFont, "CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont};
        table.putDefaults(defaults);
    }

    public static Border getButtonBorder() {
        return WindowsBorders.getButtonBorder();
    }

    public static Icon getCheckBoxIcon() {
        return WindowsIconFactory.getCheckBoxIcon();
    }

    public static Icon getRadioButtonIcon() {
        return WindowsIconFactory.getRadioButtonIcon();
    }

    private static Object[] append(Object[] source, String key, Object value) {
        int length = source.length;
        Object[] destination = new Object[length + 2];
        System.arraycopy(source, 0, destination, 0, length);
        destination[length] = key;
        destination[length + 1] = value;
        return destination;
    }

    private static Object[] append(Object[] source, Object[] keysAndValues) {
        int length = source.length;
        Object[] destination = new Object[length + keysAndValues.length];
        System.arraycopy(source, 0, destination, 0, length);
        for (int i = 0; i < keysAndValues.length; ++i) {
            destination[length + i] = keysAndValues[i];
        }
        return destination;
    }

    private static class SimpleProxyLazyValue
    implements UIDefaults.LazyValue {
        private final String className;
        private final String methodName;

        public SimpleProxyLazyValue(String c, String m) {
            this.className = c;
            this.methodName = m;
        }

        public Object createValue(UIDefaults table) {
            Object instance = null;
            try {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = table != null ? (ClassLoader)table.get("ClassLoader") : Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Class<?> c = Class.forName(this.className, true, classLoader);
                Method m = c.getMethod(this.methodName, null);
                instance = m.invoke(c, (Object[])null);
            }
            catch (Throwable t) {
                LookUtils.log("Problem creating " + this.className + " with method " + this.methodName + t);
            }
            return instance;
        }
    }
}

