/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.logviewer;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import net.sf.amemailchecker.ext.logviewer.DocumentReader;
import net.sf.amemailchecker.ext.logviewer.DocumentWriter;
import net.sf.amemailchecker.ext.logviewer.LogViewerFrame;
import net.sf.amemailchecker.ext.logviewer.LogViewerMainPanelModel;
import net.sf.amemailchecker.ext.logviewer.TailReader;
import net.sf.amemailchecker.ext.logviewer.settings.LogViewerContextHelper;
import net.sf.amemailchecker.gui.notification.NotificationType;
import net.sf.amemailchecker.gui.notification.window.modal.SystemNotificationExtendedInfoWindow;

public class LogViewerMediator {
    private static final Logger logger = Logger.getLogger(LogViewerMediator.class.getName());
    private LogViewerMainPanelModel model;
    private TailReader tailReader;
    private LogViewerFrame frame;
    private static LogViewerMediator instance;

    public void startViewer() {
        this.model = new LogViewerMainPanelModel();
        this.frame = new LogViewerFrame(this);
        this.frame.init(this.model);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                LogViewerMediator.this.stopViewer();
            }
        });
        this.frame.setSize(700, 300);
        this.frame.setVisible(true);
        File file = new File(LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern"));
        this.tailReader = new TailReader(LogViewerContextHelper.Helper.getPreferences());
        this.tailReader.read(file, new DocumentWriter(this.model.getLogViewDocument()));
    }

    public void stopViewer() {
        this.tailReader.setActive(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLogFile() throws Exception {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setSelectedFile(new File(System.getProperty("user.home")));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showSaveDialog((Component)((Object)this.frame));
        if (n != 0) {
            return;
        }
        OutputStream outputStream = null;
        DocumentReader documentReader = null;
        try {
            int n2;
            File file = jFileChooser.getSelectedFile();
            if (!file.exists()) {
                file.createNewFile();
            }
            outputStream = new FileOutputStream(file);
            documentReader = new DocumentReader(this.model.getLogViewDocument());
            char[] cArray = new char[256];
            int n3 = 0;
            while ((n2 = documentReader.read(cArray, n3, cArray.length)) != -1) {
                n3 += n2;
                ((FileOutputStream)outputStream).write(new String(cArray).getBytes());
                Arrays.fill(cArray, '\u0000');
            }
            ((FileOutputStream)outputStream).write(new String(cArray).getBytes());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            SystemNotificationExtendedInfoWindow systemNotificationExtendedInfoWindow = new SystemNotificationExtendedInfoWindow(LogViewerContextHelper.Helper.getResourceContext().getI18NBundleValueLocal("message.unable.save.file"), exception.getMessage(), (Window)((Object)this.frame));
            systemNotificationExtendedInfoWindow.showNotification(NotificationType.ERROR);
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                ((FileOutputStream)outputStream).close();
            }
            if (documentReader != null) {
                documentReader.close();
            }
        }
    }

    private LogViewerMediator() {
    }

    public static LogViewerMediator getInstance() {
        if (instance == null) {
            instance = new LogViewerMediator();
        }
        return instance;
    }
}

