/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.logviewer;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Writer;
import net.sf.amemailchecker.ext.logviewer.settings.LogViewerPreferences;

public class TailReader {
    private boolean active;
    private File file;
    private long filePos;
    private Writer output;
    private LogViewerPreferences preferences;

    public TailReader(LogViewerPreferences logViewerPreferences) {
        this.preferences = logViewerPreferences;
    }

    public void read(File file, Writer writer) {
        this.file = file;
        this.output = writer;
        this.active = true;
        new Thread(new TailReaderRunnable()).start();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    private class TailReaderRunnable
    implements Runnable {
        private TailReaderRunnable() {
        }

        @Override
        public void run() {
            try {
                while (TailReader.this.active) {
                    String string;
                    long l = TailReader.this.file.length();
                    if (l < TailReader.this.filePos) {
                        TailReader.this.filePos = l;
                    }
                    RandomAccessFile randomAccessFile = new RandomAccessFile(TailReader.this.file, "r");
                    randomAccessFile.seek(TailReader.this.filePos);
                    while ((string = randomAccessFile.readLine()) != null) {
                        TailReader.this.output.write(string);
                    }
                    TailReader.this.filePos = randomAccessFile.getFilePointer();
                    randomAccessFile.close();
                    Thread.sleep(TailReader.this.preferences.getUpdateInterval() * 1000);
                }
                TailReader.this.output.close();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }
}

