/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.logviewer.settings;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.ext.logviewer.settings.LogViewerPreferences;
import net.sf.amemailchecker.ext.logviewer.settings.LogViewerResourceContext;
import net.sf.amemailchecker.ext.logviewer.settings.LogViewerSettings;

public enum LogViewerContextHelper {
    Helper;

    private static final Logger logger;
    private LogViewerPreferences preferences = new LogViewerPreferences();
    private LogViewerResourceContext resourceContext;

    public void loadPreferences() throws Exception {
        InputStream inputStream;
        LogViewerSettings logViewerSettings = this.resourceContext.getSettings();
        Properties properties = new Properties();
        try {
            inputStream = new FileInputStream(logViewerSettings.getUserPreferencesFilePath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(logViewerSettings.getUserPreferencesFileDefault());
        }
        properties.load(inputStream);
        this.preferences.setUpdateInterval(Integer.parseInt(properties.getProperty("updateInterval")));
    }

    public void writePreferences() {
        LogViewerSettings logViewerSettings = this.resourceContext.getSettings();
        Properties properties = new Properties();
        properties.setProperty("updateInterval", Integer.toString(this.preferences.getUpdateInterval()));
        try {
            FileWriter fileWriter = new FileWriter(logViewerSettings.getUserPreferencesFilePath());
            properties.store(fileWriter, "Ame Mail Checker - Log Viewer [ user preferences ]");
        }
        catch (IOException iOException) {
            logger.log(Level.INFO, "Unable to write Log Viewer user preferences");
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
    }

    public LogViewerPreferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(LogViewerPreferences logViewerPreferences) {
        this.preferences = logViewerPreferences;
    }

    public LogViewerResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public void setResourceContext(LogViewerResourceContext logViewerResourceContext) {
        this.resourceContext = logViewerResourceContext;
    }

    static {
        logger = Logger.getLogger(LogViewerContextHelper.class.getName());
    }
}

