/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.amemailchecker.ext.addressbook.AddressBookContact;
import net.sf.amemailchecker.ext.addressbook.AddressBookGroup;
import net.sf.amemailchecker.mail.cache.PostalAddresseeCacheAdapter;
import net.sf.amemailchecker.mail.model.PostalAddressee;

public class AddressBook
implements PostalAddresseeCacheAdapter {
    private Set<AddressBookContact> contacts;
    private Map<Integer, AddressBookGroup> groups;
    private AddressBookContact personalContact;

    public Set<AddressBookContact> getContacts() {
        return this.contacts;
    }

    public void insertContacts(Set<AddressBookContact> set) {
        if (this.contacts == null) {
            this.contacts = new HashSet<AddressBookContact>();
        }
        this.contacts.addAll(set);
    }

    public Map<Integer, AddressBookGroup> getGroups() {
        return this.groups;
    }

    public void insertGroups(Map<Integer, AddressBookGroup> map) {
        if (this.groups == null) {
            this.groups = new HashMap<Integer, AddressBookGroup>();
        }
        this.groups.putAll(map);
    }

    public AddressBookGroup addGroup(String string) {
        AddressBookGroup addressBookGroup = new AddressBookGroup(string);
        int n = 0;
        for (Integer n2 : this.groups.keySet()) {
            if (n2 < n) continue;
            n += n2 == 0 ? 1 : n2;
        }
        addressBookGroup.setId(n);
        this.groups.put(n, addressBookGroup);
        return addressBookGroup;
    }

    public AddressBookContact getPersonal() {
        if (this.personalContact == null) {
            this.personalContact = new AddressBookContact();
        }
        return this.personalContact;
    }

    public void setPersonal(AddressBookContact addressBookContact) {
        this.personalContact = addressBookContact;
    }

    public void updatePersonal(String string, List<String> list) {
        this.personalContact = this.getPersonal();
        this.personalContact.setDisplayName(string);
        this.personalContact.setPostAddresses(list);
    }

    public boolean isPersonal(PostalAddressee postalAddressee) {
        for (String string : this.personalContact.getPostAddresses()) {
            if (!string.equals(postalAddressee.getAddress())) continue;
            return true;
        }
        return false;
    }

    public AddressBookContact valueOf(PostalAddressee postalAddressee) {
        AddressBookContact addressBookContact = new AddressBookContact();
        addressBookContact.setDisplayName(postalAddressee.getLabel());
        addressBookContact.getPostAddresses().add(postalAddressee.getAddress());
        return addressBookContact;
    }

    public boolean isRegistered(PostalAddressee postalAddressee) {
        AddressBookContact addressBookContact = this.findByAddress(postalAddressee.getAddress());
        return addressBookContact != null;
    }

    public AddressBookContact findByAddress(String string) {
        for (AddressBookContact addressBookContact : this.contacts) {
            for (String string2 : addressBookContact.getPostAddresses()) {
                if (!string2.equals(string)) continue;
                return addressBookContact;
            }
        }
        return null;
    }

    public void fill(PostalAddressee postalAddressee) {
        if (postalAddressee == null) {
            return;
        }
        AddressBookContact addressBookContact = this.findByAddress(postalAddressee.getAddress());
        if (addressBookContact != null) {
            postalAddressee.setLabel(addressBookContact.getLabel());
        }
    }

    public void fill(List<PostalAddressee> list) {
        for (PostalAddressee postalAddressee : list) {
            this.fill(postalAddressee);
        }
    }

    public AddressBookGroup findGroupByName(String string) {
        for (AddressBookGroup addressBookGroup : this.groups.values()) {
            if (!addressBookGroup.getName().equals(string)) continue;
            return addressBookGroup;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.contacts.size() <= 0 && this.groups.size() <= 0;
    }
}

