/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook;

import java.util.ArrayList;
import java.util.List;
import net.sf.amemailchecker.mail.model.PostalAddressee;

public class AddressBookContact
implements PostalAddressee,
Comparable<AddressBookContact> {
    private String name;
    private String surname;
    private String displayName;
    private String note;
    private List<String> postAddresses = new ArrayList<String>();
    private int groupId = -1;

    public AddressBookContact() {
    }

    public AddressBookContact(AddressBookContact addressBookContact) {
        this.name = addressBookContact.getName();
        this.surname = addressBookContact.getSurname();
        this.postAddresses.addAll(addressBookContact.getPostAddresses());
        this.note = addressBookContact.getNote();
        this.displayName = addressBookContact.getDisplayName();
        this.groupId = addressBookContact.getGroupId();
    }

    public List<String> getPostAddresses() {
        return this.postAddresses;
    }

    public void setPostAddresses(List<String> list) {
        this.postAddresses = list;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String string) {
        this.surname = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String string) {
        this.note = string;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int n) {
        this.groupId = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AddressBookContact addressBookContact = (AddressBookContact)object;
        if (this.groupId != addressBookContact.groupId) {
            return false;
        }
        if (this.name != null ? !this.name.equals(addressBookContact.name) : addressBookContact.name != null) {
            return false;
        }
        if (this.postAddresses != null ? !((Object)this.postAddresses).equals(addressBookContact.postAddresses) : addressBookContact.postAddresses != null) {
            return false;
        }
        return !(this.surname != null ? !this.surname.equals(addressBookContact.surname) : addressBookContact.surname != null);
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n = 31 * n + (this.surname != null ? this.surname.hashCode() : 0);
        n = 31 * n + (this.postAddresses != null ? ((Object)this.postAddresses).hashCode() : 0);
        n = 31 * n + this.groupId;
        return n;
    }

    @Override
    public int compareTo(AddressBookContact addressBookContact) {
        if (this.equals(addressBookContact)) {
            return 0;
        }
        if (addressBookContact.hashCode() < this.hashCode()) {
            return 1;
        }
        if (addressBookContact.hashCode() > this.hashCode()) {
            return -1;
        }
        return 0;
    }

    public String getLabel() {
        return this.displayName != null && !this.displayName.equals("") ? this.displayName : this.name + " " + this.surname;
    }

    public void setLabel(String string) {
        this.displayName = string;
    }

    public String getAddress() {
        return !this.postAddresses.isEmpty() ? this.postAddresses.get(0) : "";
    }

    public String toString() {
        return this.getLabel();
    }
}

