/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.ext.addressbook.AddressBook;
import net.sf.amemailchecker.ext.addressbook.AddressBookContact;
import net.sf.amemailchecker.ext.addressbook.AddressBookGroup;
import net.sf.amemailchecker.ext.addressbook.AddressBookXmlReader;
import net.sf.amemailchecker.ext.addressbook.AddressBookXmlWriter;
import net.sf.amemailchecker.ext.addressbook.settings.AddressBookResourceContext;

public class AddressBookProvider {
    private static final Logger logger = Logger.getLogger(AddressBookProvider.class.getName());
    private AddressBook addressBook = new AddressBook();
    private AddressBookResourceContext resourceContext;
    private static AddressBookProvider provider;

    private AddressBookProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        String string = this.resourceContext.getSettings().getAddressBookFilePath();
        try {
            new AddressBookXmlReader().read(this.addressBook, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.INFO, "Address book cannot be found under the path: [ " + string + " ]");
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            if (this.addressBook.getContacts() == null) {
                this.addressBook.insertContacts(new HashSet<AddressBookContact>());
            }
            if (this.addressBook.getGroups() == null) {
                this.addressBook.insertGroups(new HashMap<Integer, AddressBookGroup>());
            }
        }
    }

    public void write() {
        try {
            new AddressBookXmlWriter().write(this.addressBook, this.resourceContext.getSettings().getAddressBookFilePath());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public AddressBook getAddressBook() {
        return this.addressBook;
    }

    public AddressBookResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public void setResourceContext(AddressBookResourceContext addressBookResourceContext) {
        this.resourceContext = addressBookResourceContext;
    }

    public static AddressBookProvider getProvider() {
        if (provider == null) {
            provider = new AddressBookProvider();
        }
        return provider;
    }
}

