/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.amemailchecker.ext.addressbook.AddressBook;
import net.sf.amemailchecker.ext.addressbook.AddressBookContact;
import net.sf.amemailchecker.ext.addressbook.AddressBookDataSourceReader;
import net.sf.amemailchecker.ext.addressbook.AddressBookGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AddressBookXmlReader
implements AddressBookDataSourceReader {
    @Override
    public void read(AddressBook addressBook, String string) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException("File cannot be found: " + string);
        }
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        if (!document.getDocumentElement().getNodeName().equals("address-book")) {
            throw new IllegalArgumentException("The file does not contain address book data");
        }
        addressBook.insertContacts(this.readContacts(document));
        addressBook.insertGroups(this.readGroups(document));
    }

    public Map<Integer, AddressBookGroup> readGroups(Document document) {
        HashMap<Integer, AddressBookGroup> hashMap = new HashMap<Integer, AddressBookGroup>();
        NodeList nodeList = document.getElementsByTagName("group");
        if (nodeList.getLength() <= 0) {
            return hashMap;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            AddressBookGroup addressBookGroup = new AddressBookGroup();
            Element element = (Element)nodeList.item(i);
            addressBookGroup.setId(Integer.parseInt(element.getAttribute("id")));
            addressBookGroup.setName(element.getElementsByTagName("name").item(0).getTextContent());
            hashMap.put(addressBookGroup.getId(), addressBookGroup);
        }
        return hashMap;
    }

    public Set<AddressBookContact> readContacts(Document document) {
        TreeSet<AddressBookContact> treeSet = new TreeSet<AddressBookContact>();
        NodeList nodeList = document.getElementsByTagName("contact");
        if (nodeList.getLength() <= 0) {
            return treeSet;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2;
            String string;
            NodeList nodeList3;
            AddressBookContact addressBookContact = new AddressBookContact();
            treeSet.add(addressBookContact);
            Element element = (Element)nodeList.item(i);
            addressBookContact.setDisplayName(element.getElementsByTagName("display-name").item(0).getTextContent());
            NodeList nodeList4 = element.getElementsByTagName("name");
            if (nodeList4 != null && nodeList4.getLength() > 0) {
                addressBookContact.setName(nodeList4.item(0).getTextContent());
            }
            if ((nodeList3 = element.getElementsByTagName("surname")) != null && nodeList3.getLength() > 0) {
                addressBookContact.setSurname(nodeList3.item(0).getTextContent());
            }
            addressBookContact.setGroupId((string = element.getAttribute("group-id")) != null && !string.equals("") ? Integer.parseInt(string) : -1);
            NodeList nodeList5 = element.getElementsByTagName("note");
            if (nodeList5.getLength() > 0) {
                addressBookContact.setNote(nodeList5.item(0).getTextContent());
            }
            if ((nodeList2 = element.getElementsByTagName("post-address")).getLength() <= 0) continue;
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                addressBookContact.getPostAddresses().add(nodeList2.item(j).getTextContent());
            }
        }
        return treeSet;
    }
}

