/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook;

import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.amemailchecker.ext.addressbook.AddressBook;
import net.sf.amemailchecker.ext.addressbook.AddressBookContact;
import net.sf.amemailchecker.ext.addressbook.AddressBookDataSourceWriter;
import net.sf.amemailchecker.ext.addressbook.AddressBookGroup;
import net.sf.amemailchecker.util.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class AddressBookXmlWriter
extends XmlWriter
implements AddressBookDataSourceWriter {
    AddressBookXmlWriter() {
    }

    @Override
    public void write(AddressBook addressBook, String string) throws Exception {
        Element element;
        if (addressBook.isEmpty()) {
            return;
        }
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element2 = document.createElement("address-book");
        Element element3 = document.createElement("contacts");
        Element element4 = document.createElement("groups");
        for (AddressBookGroup object : addressBook.getGroups().values()) {
            element = document.createElement("group");
            element4.appendChild(element);
            this.appendChildCData("name", object.getName(), element, document);
            element.setAttribute("id", Integer.toString(object.getId()));
        }
        for (AddressBookContact addressBookContact : addressBook.getContacts()) {
            List<String> list;
            element = document.createElement("contact");
            element3.appendChild(element);
            element.setAttribute("group-id", Integer.toString(addressBookContact.getGroupId()));
            this.appendChild("name", addressBookContact.getName(), element, document);
            this.appendChild("surname", addressBookContact.getSurname(), element, document);
            this.appendChild("display-name", addressBookContact.getDisplayName(), element, document);
            if (addressBookContact.getNote() != null && !addressBookContact.getNote().equals("")) {
                this.appendChildCData("note", addressBookContact.getNote(), element, document);
            }
            if ((list = addressBookContact.getPostAddresses()).size() <= 0) continue;
            Element element5 = document.createElement("post-addresses");
            element.appendChild(element5);
            for (String string2 : list) {
                this.appendChild("post-address", string2, element5, document);
            }
        }
        element2.appendChild(element4);
        element2.appendChild(element3);
        document.appendChild(element2);
        this.transform(document, string);
    }
}

