/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.extension.action;

import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import net.sf.amemailchecker.app.extension.notification.NotificationAction;
import net.sf.amemailchecker.app.extension.notification.NotificationActionContext;
import net.sf.amemailchecker.ext.addressbook.AddressBook;
import net.sf.amemailchecker.ext.addressbook.AddressBookContact;
import net.sf.amemailchecker.ext.addressbook.AddressBookProvider;
import net.sf.amemailchecker.ext.addressbook.settings.AddressBookResourceContext;
import net.sf.amemailchecker.ext.addressbook.ui.AddressBookMediator;
import net.sf.amemailchecker.mail.model.PostalAddressee;

public class ContactAction
extends NotificationAction {
    protected AddressBook addressBook = AddressBookProvider.getProvider().getAddressBook();
    protected PostalAddressee addressee;

    public ContactAction() {
    }

    public ContactAction(PostalAddressee postalAddressee) {
        this.addressee = postalAddressee;
        this.checkRegistered(this.addressBook.isRegistered(postalAddressee));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final AddressBookContact addressBookContact = this.addressBook.isRegistered(this.addressee) ? this.addressBook.findByAddress(this.addressee.getAddress()) : this.addressBook.valueOf(this.addressee);
        final AddressBookMediator addressBookMediator = AddressBookMediator.getInstance();
        addressBookMediator.openAddressBook();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                addressBookMediator.editContact(addressBookContact);
            }
        });
    }

    public void setContext(NotificationActionContext notificationActionContext) {
        super.setContext(notificationActionContext);
        this.addressee = notificationActionContext.getLetter().getSender();
        this.checkRegistered(this.addressBook.isRegistered(this.addressee));
    }

    protected void checkRegistered(boolean bl) {
        AddressBookResourceContext addressBookResourceContext = AddressBookProvider.getProvider().getResourceContext();
        if (bl) {
            this.putValue("Name", addressBookResourceContext.getI18NBundleValueLocal("action.contact.edit.label"));
        } else {
            this.putValue("Name", addressBookResourceContext.getI18NBundleValueLocal("action.contact.add.label"));
        }
    }
}

