/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.extension.point;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsActionContext;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsActionExtensionPoint;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsChangeListener;
import net.sf.amemailchecker.app.model.RecipientDocument;
import net.sf.amemailchecker.ext.addressbook.AddressBookProvider;
import net.sf.amemailchecker.ext.addressbook.settings.AddressBookResourceContext;
import net.sf.amemailchecker.ext.addressbook.ui.ContactSelectionExtendedDialog;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.component.button.DropDownMenuButton;

public class AddressBookLetterDetailsExtensionPoint
implements LetterDetailsActionExtensionPoint {
    private static final String RECIPIENT_TYPE_TO = "To";
    private static final String RECIPIENT_TYPE_CC = "CC";
    private AddressBookResourceContext bundle = AddressBookProvider.getProvider().getResourceContext();

    public boolean containsActions(LetterDetailsActionExtensionPoint.State state) {
        return state.equals((Object)LetterDetailsActionExtensionPoint.State.EDIT);
    }

    public LetterDetailsChangeListener letterChangeListener() {
        return null;
    }

    public DropDownMenuButton[] action(LetterDetailsActionContext letterDetailsActionContext, LetterDetailsActionExtensionPoint.State state) {
        if (!this.containsActions(state)) {
            return null;
        }
        DropDownMenuButton dropDownMenuButton = (DropDownMenuButton)ActionControlFactory.Factory.constructActionPanelButton((AbstractButton)new DropDownMenuButton(false), this.bundle.getI18NBundleValueLocal("action.add.recipients.label"), this.bundle.loadImageIcon("icon.action.add.recipients"));
        dropDownMenuButton.setPopupMenu(this.getRecipientsMenu(letterDetailsActionContext).getPopupMenu());
        return new DropDownMenuButton[]{dropDownMenuButton};
    }

    private JMenu getRecipientsMenu(final LetterDetailsActionContext letterDetailsActionContext) {
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem(this.bundle.getI18NBundleValue("message.field.to"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBookLetterDetailsExtensionPoint.this.performRecipientSelection(AddressBookLetterDetailsExtensionPoint.RECIPIENT_TYPE_TO, letterDetailsActionContext);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(this.bundle.getI18NBundleValue("message.field.cc"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBookLetterDetailsExtensionPoint.this.performRecipientSelection(AddressBookLetterDetailsExtensionPoint.RECIPIENT_TYPE_CC, letterDetailsActionContext);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    private void performRecipientSelection(final String string, final LetterDetailsActionContext letterDetailsActionContext) {
        final ContactSelectionExtendedDialog contactSelectionExtendedDialog = new ContactSelectionExtendedDialog(letterDetailsActionContext.getOwner());
        contactSelectionExtendedDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecipientDocument recipientDocument = string.equals(AddressBookLetterDetailsExtensionPoint.RECIPIENT_TYPE_TO) ? letterDetailsActionContext.getModel().getTo() : letterDetailsActionContext.getModel().getCc();
                try {
                    recipientDocument.fill(contactSelectionExtendedDialog.getSelectedValue());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        contactSelectionExtendedDialog.setVisible(true);
    }
}

