/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.notification.widget.SpinWidget;

public class ActionListComposite
extends JPanel {
    private JList list;
    private JTextField inputField;
    private JButton applyButton;
    private JButton addButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;
    private ListModel listModel;
    private JPanel editPanel;
    private boolean editPanelExpandable = true;
    private boolean useRearrangeAction;
    private Object[] changedElements;

    public ActionListComposite() {
        this.setLayout(new BorderLayout());
    }

    public void init(ListModel listModel, ResourceContext resourceContext) {
        Serializable serializable;
        Object object;
        this.listModel = listModel;
        this.list = new JList();
        this.list.setModel(listModel);
        this.list.setCellRenderer(new AddressListCompositeRenderer());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.list);
        ActionControlFactory actionControlFactory = ActionControlFactory.Factory;
        this.applyButton = actionControlFactory.createSimpleActionButton(resourceContext.loadImageIcon("icon.apply"));
        this.addButton = actionControlFactory.createSimpleActionButton(resourceContext.loadImageIcon("icon.add"));
        this.deleteButton = actionControlFactory.createSimpleActionButton(resourceContext.loadImageIcon("icon.delete"));
        this.inputField = new JTextField();
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new BoxLayout(this.editPanel, 0));
        this.editPanel.add(this.inputField);
        this.editPanel.add(Box.createHorizontalStrut(3));
        this.editPanel.add(this.applyButton);
        this.editPanel.add(Box.createHorizontalStrut(3));
        this.editPanel.add(this.addButton);
        this.editPanel.add(Box.createHorizontalStrut(3));
        this.editPanel.add(this.deleteButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        if (this.editPanelExpandable) {
            this.editPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            object = new SpinWidget(15, 15, Color.BLACK, Color.BLACK);
            object.addMouseListener((MouseListener)new MouseAdapter((SpinWidget)object){
                final /* synthetic */ SpinWidget val$spinWidget;
                {
                    this.val$spinWidget = spinWidget;
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ActionListComposite.this.editPanel.setVisible(this.val$spinWidget.isExpanded());
                    ActionListComposite.this.repaint();
                }
            });
            object.setExpanded(false);
            this.editPanel.setVisible(false);
            serializable = new JPanel();
            ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 1));
            ((Container)serializable).add((Component)object);
            ((Container)serializable).add(this.editPanel);
            jPanel.add((Component)serializable, "South");
        } else {
            jPanel.add((Component)this.editPanel, "South");
        }
        if (this.useRearrangeAction) {
            this.upButton = actionControlFactory.createSimpleActionButton(resourceContext.loadImageIcon("icon.arrow.up"));
            this.downButton = actionControlFactory.createSimpleActionButton(resourceContext.loadImageIcon("icon.arrow.down"));
            object = new JPanel();
            ((Container)object).setLayout(new GridBagLayout());
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).gridy = 0;
            ((Container)object).add((Component)this.upButton, serializable);
            ((GridBagConstraints)serializable).gridy = 1;
            ((Container)object).add((Component)this.downButton, serializable);
            this.add((Component)object, "East");
        }
        this.add((Component)jPanel, "Center");
        this.addListeners();
    }

    private void addListeners() {
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ActionListComposite.this.inputField.setText((String)ActionListComposite.this.list.getSelectedValue());
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((DefaultListModel)ActionListComposite.this.listModel).addElement(ActionListComposite.this.inputField.getText());
                ActionListComposite.this.inputField.setText("");
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ActionListComposite.this.list.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                String string = ((DefaultListModel)ActionListComposite.this.listModel).set(n, ActionListComposite.this.inputField.getText());
                ActionListComposite.access$402(ActionListComposite.this, new Object[]{string});
                ActionListComposite.this.inputField.setText("");
                ActionListComposite.this.list.clearSelection();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ActionListComposite.this.list.getSelectedIndices();
                if (nArray.length <= 0) {
                    return;
                }
                ActionListComposite.access$402(ActionListComposite.this, new Object[nArray.length]);
                for (int i = 0; i < nArray.length; ++i) {
                    ((ActionListComposite)ActionListComposite.this).changedElements[i] = ((DefaultListModel)ActionListComposite.this.listModel).remove(nArray[i]);
                }
                ActionListComposite.this.inputField.setText("");
            }
        });
        if (this.useRearrangeAction) {
            this.upButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ActionListComposite.this.list.getSelectedIndex();
                    ActionListComposite.this.switchListValues(n, n - 1);
                    ActionListComposite.this.list.setSelectedIndex(n - 1);
                }
            });
            this.downButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ActionListComposite.this.list.getSelectedIndex();
                    ActionListComposite.this.switchListValues(n + 1, n);
                    ActionListComposite.this.list.setSelectedIndex(n + 1);
                }
            });
        }
    }

    public void switchListValues(int n, int n2) {
        int n3 = this.list.getModel().getSize();
        if (n <= 0 || n2 >= n3 - 1) {
            return;
        }
        Object e = this.list.getModel().getElementAt(n);
        Object e2 = this.list.getModel().getElementAt(n2);
        ((DefaultListModel)this.list.getModel()).setElementAt(e2, n);
        ((DefaultListModel)this.list.getModel()).setElementAt(e, n2);
    }

    public JList getList() {
        return this.list;
    }

    public Object[] getChangedElements() {
        return this.changedElements;
    }

    public boolean isEditPanelExpandable() {
        return this.editPanelExpandable;
    }

    public void setEditPanelExpandable(boolean bl) {
        this.editPanelExpandable = bl;
    }

    public boolean isUseRearrangeAction() {
        return this.useRearrangeAction;
    }

    public void setUseRearrangeAction(boolean bl) {
        this.useRearrangeAction = bl;
    }

    static /* synthetic */ Object[] access$402(ActionListComposite actionListComposite, Object[] objectArray) {
        actionListComposite.changedElements = objectArray;
        return objectArray;
    }

    public class AddressListCompositeRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            if (n == 0 && ActionListComposite.this.useRearrangeAction) {
                this.setForeground(Color.BLUE);
            }
            return this;
        }
    }
}

