/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.ui;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import net.sf.amemailchecker.ext.addressbook.AddressBook;
import net.sf.amemailchecker.ext.addressbook.AddressBookContact;
import net.sf.amemailchecker.ext.addressbook.AddressBookGroup;
import net.sf.amemailchecker.ext.addressbook.AddressBookProvider;
import net.sf.amemailchecker.ext.addressbook.AddressBookXmlReader;
import net.sf.amemailchecker.ext.addressbook.ui.AddressBookModel;
import net.sf.amemailchecker.ext.addressbook.ui.AddressBookWindow;
import net.sf.amemailchecker.ext.addressbook.ui.ContactEditDialog;
import net.sf.amemailchecker.ext.addressbook.ui.ContactEditPanelModel;
import net.sf.amemailchecker.gui.notification.NotificationType;
import net.sf.amemailchecker.gui.notification.window.modal.SystemNotificationExtendedInfoWindow;

public class AddressBookMediator {
    private static final Logger logger = Logger.getLogger(AddressBookMediator.class.getName());
    private ContactEditPanelModel currentContactModel;
    private AddressBookWindow addressBookWindow;
    private AddressBookModel addressBookModel;
    private AddressBook addressBook = AddressBookProvider.getProvider().getAddressBook();
    private static AddressBookMediator instance;

    public void openAddressBook() {
        this.addressBookWindow = new AddressBookWindow(this);
        this.addressBookModel = new AddressBookModel();
        this.addressBookModel.fill(this.addressBook);
        this.addressBookWindow.init(this.addressBookModel);
        this.addressBookWindow.setVisible(true);
    }

    public void removeContact() {
        int[] nArray;
        this.currentContactModel = null;
        for (int n : nArray = this.addressBookWindow.getContactsTable().getSelectedRows()) {
            AddressBookContact addressBookContact = this.addressBookModel.getContactsTableModel().getObjectAt(n);
            this.addressBook.getContacts().remove(addressBookContact);
            this.addressBookModel.getContactsTableModel().removeRow(n);
        }
    }

    public void editContact(AddressBookContact addressBookContact) {
        this.currentContactModel = new ContactEditPanelModel(addressBookContact == null ? new AddressBookContact() : addressBookContact);
        this.openEditDialog();
    }

    public void acceptContactModify() {
        AddressBookContact addressBookContact = this.currentContactModel.acceptChanges();
        if (!this.addressBook.isRegistered(addressBookContact)) {
            this.addressBook.getContacts().add(addressBookContact);
            this.addressBookModel.getContactsTableModel().addRow(addressBookContact);
        }
    }

    public void addGroup(String string) {
        AddressBookGroup addressBookGroup = this.addressBook.findGroupByName(string);
        if (addressBookGroup == null) {
            addressBookGroup = this.addressBook.addGroup(string);
        }
        this.addressBookModel.getGroupComboModel().addElement((Object)addressBookGroup.getId(), addressBookGroup.getName());
    }

    public void removeGroup(String string) {
        AddressBookGroup addressBookGroup = this.addressBook.findGroupByName(string);
        this.addressBook.getGroups().remove(addressBookGroup.getId());
        this.addressBookModel.getGroupComboModel().removeElementFor((Object)addressBookGroup.getId());
        this.addressBookModel.getContactsTableModel().fireTableDataChanged();
    }

    public void editGroup(String string, String string2) {
        AddressBookGroup addressBookGroup = this.addressBook.findGroupByName(string);
        addressBookGroup.setName(string2);
        this.addressBookModel.getGroupComboModel().replaceElementFor(string, string2, (Object)addressBookGroup.getId());
        this.addressBookModel.getContactsTableModel().fireTableDataChanged();
    }

    public void saveChanges() {
        AddressBookProvider.getProvider().write();
    }

    private void openEditDialog() {
        ContactEditDialog contactEditDialog = new ContactEditDialog(this.currentContactModel, (JFrame)((Object)this.addressBookWindow));
        contactEditDialog.setMediator(this);
        contactEditDialog.init();
        contactEditDialog.setVisible(true);
    }

    public void importBook() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setSelectedFile(new File(System.getProperty("user.home")));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith("xml");
            }

            @Override
            public String getDescription() {
                return "*.xml";
            }
        });
        int n = jFileChooser.showOpenDialog((Component)((Object)this.addressBookWindow));
        if (n != 0) {
            return;
        }
        try {
            new AddressBookXmlReader().read(this.addressBook, jFileChooser.getSelectedFile().getPath());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            SystemNotificationExtendedInfoWindow systemNotificationExtendedInfoWindow = new SystemNotificationExtendedInfoWindow(AddressBookProvider.getProvider().getResourceContext().getI18NBundleValueLocal("message.import.book.error"), exception.getMessage(), (Window)((Object)this.addressBookWindow));
            systemNotificationExtendedInfoWindow.showNotification(NotificationType.ERROR);
        }
        this.addressBookModel.fireModelUpdate(this.addressBook);
    }

    private AddressBookMediator() {
    }

    public static AddressBookMediator getInstance() {
        if (instance == null) {
            instance = new AddressBookMediator();
        }
        return instance;
    }
}

