/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.ui;

import java.util.Collection;
import javax.swing.DefaultListModel;
import net.sf.amemailchecker.app.model.ValueIDComboModel;
import net.sf.amemailchecker.ext.addressbook.AddressBook;
import net.sf.amemailchecker.ext.addressbook.AddressBookGroup;
import net.sf.amemailchecker.ext.addressbook.ui.DefaultContactsTableModel;
import net.sf.amemailchecker.ext.addressbook.ui.GroupContactsTableModel;

public class AddressBookModel {
    private GroupContactsTableModel contactsTableModel;
    private DefaultListModel groupListModel;
    private ValueIDComboModel<Integer> groupComboModel;

    void fill(AddressBook addressBook) {
        this.contactsTableModel = new GroupContactsTableModel();
        this.groupListModel = new DefaultListModel();
        this.groupComboModel = new ValueIDComboModel();
        this.groupComboModel.addElement((Object)-1, "");
        this.fireModelUpdate(addressBook);
    }

    void fireModelUpdate(AddressBook addressBook) {
        this.contactsTableModel.expandToModel(addressBook.getContacts());
        Collection<AddressBookGroup> collection = addressBook.getGroups().values();
        for (AddressBookGroup addressBookGroup : collection) {
            if (!this.groupListModel.contains(addressBookGroup.getName())) {
                this.groupListModel.addElement(addressBookGroup.getName());
            }
            if (this.groupComboModel.contains(addressBookGroup.getName())) continue;
            this.groupComboModel.addElement((Object)addressBookGroup.getId(), addressBookGroup.getName());
        }
    }

    public DefaultContactsTableModel getContactsTableModel() {
        return this.contactsTableModel;
    }

    public DefaultListModel getGroupListModel() {
        return this.groupListModel;
    }

    public ValueIDComboModel<Integer> getGroupComboModel() {
        return this.groupComboModel;
    }
}

