/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableRowSorter;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.ext.addressbook.AddressBookProvider;
import net.sf.amemailchecker.ext.addressbook.settings.AddressBookResourceContext;
import net.sf.amemailchecker.ext.addressbook.ui.ActionListComposite;
import net.sf.amemailchecker.ext.addressbook.ui.AddressBookActionPanel;
import net.sf.amemailchecker.ext.addressbook.ui.AddressBookMediator;
import net.sf.amemailchecker.ext.addressbook.ui.AddressBookModel;
import net.sf.amemailchecker.ext.addressbook.ui.ContactsTable;
import net.sf.amemailchecker.ext.addressbook.ui.ContactsTableMouseListener;
import net.sf.amemailchecker.ext.addressbook.ui.GroupContactsTable;
import net.sf.amemailchecker.ext.addressbook.ui.GroupRowFilter;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.BaseFrame;

public class AddressBookWindow
extends BaseFrame {
    private AddressBookMediator mediator;
    private GroupContactsTable table;
    private ActionListComposite groupList;
    GroupRowFilter groupRowFilter;

    public AddressBookWindow(AddressBookMediator addressBookMediator) {
        this.mediator = addressBookMediator;
    }

    public void init(AddressBookModel addressBookModel) {
        AddressBookResourceContext addressBookResourceContext = AddressBookProvider.getProvider().getResourceContext();
        super.init((ResourceContext)addressBookResourceContext);
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(addressBookResourceContext.getI18NBundleValueLocal("dialog.address.book.title"));
        this.groupRowFilter = new GroupRowFilter();
        this.table = new GroupContactsTable();
        this.table.init(addressBookModel.getContactsTableModel());
        this.table.addMouseListener(new ContactsTableMouseListener(this.mediator, this.table));
        this.table.setGroupValues(addressBookModel.getGroupComboModel());
        JPanel jPanel = ContactsTable.getWrapperInstance(this.table, new RowFilter[]{this.groupRowFilter});
        AddressBookActionPanel addressBookActionPanel = new AddressBookActionPanel(this.mediator);
        this.groupList = new ActionListComposite();
        this.groupList.setBorder(BorderFactory.createTitledBorder(addressBookResourceContext.getI18NBundleValue("label.groups")));
        this.groupList.setPreferredSize(new Dimension(250, this.groupList.getPreferredSize().height));
        this.groupList.init(addressBookModel.getGroupListModel(), addressBookResourceContext);
        this.groupList.getList().getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                AddressBookWindow.this.mediator.addGroup(((DefaultListModel)listDataEvent.getSource()).get(listDataEvent.getIndex0()).toString());
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AddressBookWindow.this.groupRowFilter.setFilterValue(null);
                        for (Object object : AddressBookWindow.this.groupList.getChangedElements()) {
                            AddressBookWindow.this.mediator.removeGroup(object.toString());
                        }
                    }
                });
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                final String string = ((DefaultListModel)listDataEvent.getSource()).get(listDataEvent.getIndex0()).toString();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (Object object : AddressBookWindow.this.groupList.getChangedElements()) {
                            AddressBookWindow.this.mediator.editGroup(object.toString(), string);
                        }
                    }
                });
            }
        });
        this.groupList.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JList jList = (JList)mouseEvent.getSource();
                if (jList.getModel().getSize() <= 0) {
                    return;
                }
                int n = jList.locationToIndex(mouseEvent.getPoint());
                String string = (String)jList.getModel().getElementAt(n);
                TableRowSorter tableRowSorter = (TableRowSorter)AddressBookWindow.this.table.getRowSorter();
                if (string == null || AddressBookWindow.this.groupRowFilter.isFilterValue(string)) {
                    AddressBookWindow.this.groupRowFilter.setFilterValue(null);
                    jList.clearSelection();
                    jList.getParent().requestFocusInWindow();
                } else {
                    RowFilter rowFilter = tableRowSorter.getRowFilter();
                    if (rowFilter == null) {
                        tableRowSorter.setRowFilter(AddressBookWindow.this.groupRowFilter);
                    }
                    AddressBookWindow.this.groupRowFilter.setFilterValue(string);
                }
                tableRowSorter.sort();
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.groupList);
        this.getContentPane().add((Component)addressBookActionPanel, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jScrollPane, "West");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddressBookWindow.this.mediator.saveChanges();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(addressBookResourceContext.getI18NBundleValue("action.file"));
        jMenu.add(ActionControlFactory.Factory.getJMenuItem(addressBookResourceContext.getI18NBundleValue("action.import"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBookWindow.this.mediator.importBook();
            }
        }));
        jMenu.add(ActionControlFactory.Factory.getJMenuItem(addressBookResourceContext.getI18NBundleValue("action.save"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBookWindow.this.mediator.saveChanges();
            }
        }));
        jMenu.addSeparator();
        jMenu.add(ActionControlFactory.Factory.getJMenuItem(addressBookResourceContext.getI18NBundleValue("action.close.label"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBookWindow.this.setVisible(false);
            }
        }));
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    GroupContactsTable getContactsTable() {
        return this.table;
    }
}

