/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.amemailchecker.ext.addressbook.AddressBookContact;
import net.sf.amemailchecker.ext.addressbook.AddressBookProvider;
import net.sf.amemailchecker.ext.addressbook.settings.AddressBookResourceContext;
import net.sf.amemailchecker.ext.addressbook.ui.ContactAddressSelectionModel;
import net.sf.amemailchecker.ext.addressbook.ui.ContactsTable;
import net.sf.amemailchecker.gui.ActionControlFactory;

public class ContactAddressSelectionPanel
extends JPanel {
    private ContactsTable table;
    private JComboBox addressesBox;
    private JList addressesList;
    private JButton addAddressBtn;
    private JButton removeAddressBtn;
    private ContactAddressSelectionModel model;

    public ContactAddressSelectionPanel(ContactsTable contactsTable) {
        this.table = contactsTable;
    }

    public void init(ContactAddressSelectionModel contactAddressSelectionModel) {
        this.model = contactAddressSelectionModel;
        this.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 150));
        this.addressesBox = new JComboBox();
        this.addressesList = new JList(contactAddressSelectionModel.getAddressesListModel());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.getViewport().add(this.addressesList);
        ActionControlFactory actionControlFactory = ActionControlFactory.Factory;
        AddressBookResourceContext addressBookResourceContext = AddressBookProvider.getProvider().getResourceContext();
        this.addAddressBtn = actionControlFactory.createSimpleActionButton(addressBookResourceContext.loadImageIcon("icon.add"));
        this.removeAddressBtn = actionControlFactory.createSimpleActionButton(addressBookResourceContext.loadImageIcon("icon.delete"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.addAddressBtn);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.removeAddressBtn);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.addressesBox);
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.addListeners();
    }

    private void addListeners() {
        this.addAddressBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ContactAddressSelectionPanel.this.addressesBox.getSelectedItem().toString();
                if (ContactAddressSelectionPanel.this.model.contains(string)) {
                    return;
                }
                ContactAddressSelectionPanel.this.model.getAddressesListModel().addElement(string);
            }
        });
        this.removeAddressBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ContactAddressSelectionPanel.this.addressesList.getSelectedIndices();
                DefaultListModel defaultListModel = ContactAddressSelectionPanel.this.model.getAddressesListModel();
                synchronized (defaultListModel) {
                    for (int n : nArray) {
                        ContactAddressSelectionPanel.this.model.getAddressesListModel().remove(n);
                    }
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 1) {
                    ContactAddressSelectionPanel.this.addressesBox.removeAllItems();
                    int n = ContactAddressSelectionPanel.this.table.rowAtPoint(mouseEvent.getPoint());
                    AddressBookContact addressBookContact = ContactAddressSelectionPanel.this.table.getModel().getObjectAt(n);
                    for (String string : addressBookContact.getPostAddresses()) {
                        ContactAddressSelectionPanel.this.addressesBox.addItem(string);
                    }
                    ContactAddressSelectionPanel.this.addressesBox.repaint();
                    ContactAddressSelectionPanel.this.setEnabled(ContactAddressSelectionPanel.this.addressesBox.getItemCount() > 0);
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.addressesBox.setEnabled(bl);
        this.addAddressBtn.setEnabled(bl);
        this.removeAddressBtn.setEnabled(bl);
        this.addressesList.setEnabled(bl);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.setEnabled(this.addressesBox.getItemCount() > 0);
    }
}

