/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.ext.addressbook.AddressBookProvider;
import net.sf.amemailchecker.ext.addressbook.settings.AddressBookResourceContext;
import net.sf.amemailchecker.ext.addressbook.ui.AddressBookMediator;
import net.sf.amemailchecker.ext.addressbook.ui.ContactEditPanel;
import net.sf.amemailchecker.ext.addressbook.ui.ContactEditPanelModel;
import net.sf.amemailchecker.gui.BaseDialog;

public class ContactEditDialog
extends BaseDialog {
    private ContactEditPanelModel model;
    private AddressBookMediator mediator;

    public ContactEditDialog(ContactEditPanelModel contactEditPanelModel, JFrame jFrame) {
        super(jFrame, true);
        this.model = contactEditPanelModel;
    }

    public void init() {
        AddressBookResourceContext addressBookResourceContext = AddressBookProvider.getProvider().getResourceContext();
        super.init((ResourceContext)addressBookResourceContext);
        this.setTitle(addressBookResourceContext.getI18NBundleValueLocal("dialog.address.book.contact.edit.title"));
        ContactEditPanel contactEditPanel = new ContactEditPanel();
        contactEditPanel.init(this.model);
        this.cancel.setText(addressBookResourceContext.getI18NBundleValue("action.cancel.label"));
        this.accept.setText(addressBookResourceContext.getI18NBundleValue("action.accept.label"));
        this.accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContactEditDialog.this.mediator.acceptContactModify();
                ContactEditDialog.this.setVisible(false);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)contactEditPanel, "Center");
        this.getContentPane().add((Component)this.commonButtonPanel, "South");
    }

    public void setMediator(AddressBookMediator addressBookMediator) {
        this.mediator = addressBookMediator;
    }
}

