/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.ui;

import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import net.sf.amemailchecker.app.model.UIPanelModel;
import net.sf.amemailchecker.ext.addressbook.AddressBookContact;

public class ContactEditPanelModel
implements UIPanelModel<AddressBookContact> {
    private AddressBookContact contact;
    private DefaultListModel postAddressesModel;
    private Document displayNameModel;
    private Document nameModel;
    private Document surnameModel;
    private Document noteModel;

    public ContactEditPanelModel(AddressBookContact addressBookContact) {
        this.fireModelUpdate(addressBookContact);
    }

    public void fill() {
        this.postAddressesModel = new DefaultListModel();
        for (String string : this.contact.getPostAddresses()) {
            this.postAddressesModel.addElement(string);
        }
        this.displayNameModel = new PlainDocument();
        this.nameModel = new PlainDocument();
        this.surnameModel = new PlainDocument();
        this.noteModel = new PlainDocument();
        try {
            this.displayNameModel.insertString(0, this.contact.getDisplayName(), null);
            this.nameModel.insertString(0, this.contact.getName(), null);
            this.surnameModel.insertString(0, this.contact.getSurname(), null);
            this.noteModel.insertString(0, this.contact.getNote(), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public AddressBookContact acceptChanges() {
        this.contact.getPostAddresses().clear();
        Enumeration enumeration = this.postAddressesModel.elements();
        while (enumeration.hasMoreElements()) {
            this.contact.getPostAddresses().add((String)enumeration.nextElement());
        }
        try {
            this.contact.setDisplayName(this.displayNameModel.getText(0, this.displayNameModel.getLength()));
            this.contact.setName(this.nameModel.getText(0, this.nameModel.getLength()));
            this.contact.setSurname(this.surnameModel.getText(0, this.surnameModel.getLength()));
            this.contact.setNote(this.noteModel.getText(0, this.noteModel.getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return this.contact;
    }

    public AddressBookContact declineChanges() {
        return this.contact;
    }

    public void fireModelUpdate(AddressBookContact addressBookContact) {
        this.contact = addressBookContact;
        this.fill();
    }

    public DefaultListModel getPostAddressesModel() {
        return this.postAddressesModel;
    }

    public Document getDisplayNameModel() {
        return this.displayNameModel;
    }

    public Document getNameModel() {
        return this.nameModel;
    }

    public Document getSurnameModel() {
        return this.surnameModel;
    }

    public Document getNoteModel() {
        return this.noteModel;
    }
}

