/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.ext.addressbook.AddressBookContact;
import net.sf.amemailchecker.ext.addressbook.AddressBookProvider;
import net.sf.amemailchecker.ext.addressbook.settings.AddressBookResourceContext;
import net.sf.amemailchecker.ext.addressbook.ui.ContactsTable;
import net.sf.amemailchecker.ext.addressbook.ui.DefaultContactsTableModel;
import net.sf.amemailchecker.gui.BaseDialog;
import net.sf.amemailchecker.mail.model.PostalAddressee;

public class ContactSelectionSimpleDialog
extends BaseDialog {
    protected ContactsTable table;
    protected JPanel commonPanel;

    public ContactSelectionSimpleDialog() {
        this.init();
    }

    public ContactSelectionSimpleDialog(Window window) {
        super(window);
        this.init();
    }

    public void init() {
        AddressBookResourceContext addressBookResourceContext = AddressBookProvider.getProvider().getResourceContext();
        super.init((ResourceContext)addressBookResourceContext);
        this.setTitle(addressBookResourceContext.getI18NBundleValueLocal("dialog.contact.select.title"));
        DefaultContactsTableModel defaultContactsTableModel = new DefaultContactsTableModel();
        defaultContactsTableModel.expandToModel(AddressBookProvider.getProvider().getAddressBook().getContacts());
        this.table = new ContactsTable();
        this.table.init(defaultContactsTableModel);
        this.cancel.setText(addressBookResourceContext.getI18NBundleValue("action.cancel.label"));
        this.accept.setText(addressBookResourceContext.getI18NBundleValue("action.accept.label"));
        this.accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ContactSelectionSimpleDialog.this.setVisible(false);
                    }
                });
            }
        });
        JPanel jPanel = ContactsTable.getWrapperInstance(this.table, null);
        this.commonPanel = new JPanel();
        this.commonPanel.setLayout(new BorderLayout());
        this.commonPanel.add((Component)jPanel, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.commonPanel, "Center");
        this.getContentPane().add((Component)this.commonButtonPanel, "South");
        this.setSize(400, 600);
    }

    public void addActionListener(ActionListener actionListener) {
        this.accept.addActionListener(actionListener);
    }

    public synchronized List<PostalAddressee> getSelectedValue() {
        int[] nArray = this.table.getSelectedRows();
        ArrayList<PostalAddressee> arrayList = new ArrayList<PostalAddressee>();
        for (int n : nArray) {
            AddressBookContact addressBookContact = this.table.getModel().getObjectAt(n);
            arrayList.add(addressBookContact);
        }
        return arrayList;
    }
}

