/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableRowSorter;
import net.sf.amemailchecker.ext.addressbook.AddressBookProvider;
import net.sf.amemailchecker.ext.addressbook.settings.AddressBookResourceContext;
import net.sf.amemailchecker.ext.addressbook.ui.DefaultContactsTableModel;

public class ContactsTableFilterPanel
extends JPanel {
    private JTextField filter;
    private TableRowSorter sorter;
    private List<RowFilter<DefaultContactsTableModel, Integer>> filters;

    public ContactsTableFilterPanel(TableRowSorter tableRowSorter) {
        this.sorter = tableRowSorter;
        this.filters = new ArrayList<RowFilter<DefaultContactsTableModel, Integer>>();
        this.init();
    }

    private void init() {
        AddressBookResourceContext addressBookResourceContext = AddressBookProvider.getProvider().getResourceContext();
        this.filter = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(addressBookResourceContext.getI18NBundleValue("label.filter")));
        this.add(Box.createHorizontalStrut(10));
        this.add(this.filter);
        this.filter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ContactsTableFilterPanel.this.applyFilter(ContactsTableFilterPanel.this.filter.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ContactsTableFilterPanel.this.applyFilter(ContactsTableFilterPanel.this.filter.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ContactsTableFilterPanel.this.applyFilter(ContactsTableFilterPanel.this.filter.getText());
            }
        });
    }

    public void applyFilter(String string) {
        RowFilter rowFilter = RowFilter.regexFilter(Pattern.quote(string), 0);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.filters);
        arrayList.add(rowFilter);
        this.sorter.setRowFilter(RowFilter.andFilter(arrayList));
    }

    public void addFilter(RowFilter<DefaultContactsTableModel, Integer> rowFilter) {
        this.filters.add(rowFilter);
    }
}

