/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import net.sf.amemailchecker.ext.addressbook.AddressBookContact;
import net.sf.amemailchecker.ext.addressbook.ui.ContactsTableModel;

public class DefaultContactsTableModel
extends DefaultTableModel
implements ContactsTableModel {
    protected Map<Integer, AddressBookContact> values = new HashMap<Integer, AddressBookContact>();

    @Override
    public void expandToModel(Collection<AddressBookContact> collection) {
        for (AddressBookContact addressBookContact : collection) {
            this.addRow(addressBookContact);
        }
    }

    @Override
    public AddressBookContact getObjectAt(int n) {
        return this.values.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        AddressBookContact addressBookContact = this.values.get(n);
        switch (n2) {
            case 0: {
                return addressBookContact.getName();
            }
            case 1: {
                return addressBookContact.getSurname();
            }
        }
        return super.getValueAt(n, n2);
    }

    @Override
    public void addRow(AddressBookContact addressBookContact) {
        if (this.values.containsValue(addressBookContact)) {
            return;
        }
        this.values.put(super.getRowCount(), addressBookContact);
        this.addRow(new Object[]{addressBookContact.getName(), addressBookContact.getSurname()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRow(int n) {
        super.removeRow(n);
        DefaultContactsTableModel defaultContactsTableModel = this;
        synchronized (defaultContactsTableModel) {
            HashMap<Integer, AddressBookContact> hashMap = new HashMap<Integer, AddressBookContact>();
            for (Integer n2 : this.values.keySet()) {
                AddressBookContact addressBookContact = this.values.get(n2);
                if (n2 > n) {
                    n2 = n2 - 1;
                }
                hashMap.put(n2, addressBookContact);
            }
            this.values.clear();
            this.values = hashMap;
        }
    }
}

