/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.ext.addressbook.ui;

import java.util.HashMap;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ReflectDocumentListener
implements DocumentListener {
    private Document[] documents;
    private Map<Document, Integer> rDocuments = new HashMap<Document, Integer>();

    public ReflectDocumentListener(Document[] documentArray) {
        this.documents = documentArray;
    }

    private int getStartOffset(Document document) {
        int n;
        if (!this.rDocuments.containsKey(document)) {
            n = this.documents[0].getLength();
            this.rDocuments.put(document, n);
        } else {
            n = this.rDocuments.get(document);
        }
        return n;
    }

    private void arrange(int n, int n2, boolean bl) {
        for (Document document : this.rDocuments.keySet()) {
            int n3 = this.rDocuments.get(document);
            if (n3 <= n) continue;
            this.rDocuments.put(document, bl ? n3 + n2 : n3 - n2);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        int n = this.getStartOffset(document);
        try {
            String string = document.getText(documentEvent.getOffset(), documentEvent.getLength());
            for (Document document2 : this.documents) {
                document2.insertString(n + documentEvent.getOffset(), string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.arrange(n, documentEvent.getLength(), true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        int n = this.getStartOffset(document);
        try {
            for (Document document2 : this.documents) {
                document2.remove(n + documentEvent.getOffset(), documentEvent.getLength());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.arrange(n, documentEvent.getLength(), false);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }
}

