/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.app.ResourceLoader;
import net.sf.amemailchecker.app.Version;
import net.sf.amemailchecker.app.account.AccountsCache;
import net.sf.amemailchecker.app.model.Settings;
import net.sf.amemailchecker.app.model.UserData;
import net.sf.amemailchecker.app.model.io.UserDataReader;
import net.sf.amemailchecker.app.model.io.UserDataWriter;
import net.sf.amemailchecker.app.model.io.UserPreferencesHelper;
import net.sf.amemailchecker.app.state.StateContext;
import net.sf.amemailchecker.db.common.DBDataSourceFactory;

public final class ApplicationContext
implements ResourceContext {
    private static ApplicationContext instance;
    private Map<String, Object> objectMap = new TreeMap<String, Object>();
    private StateContext stateContext;
    private ResourceLoader resourceLoader = new ResourceLoader();
    private Version version;
    private Map<String, Map<String, String>> i18nBundleExt = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> iconBundleExt = new HashMap<String, Map<String, String>>();
    private Settings settings;
    private Map<String, String> i18nBundle;
    private Map<String, String> exceptionCodesBundle;
    private Map<String, String> iconBundle;
    private Map<String, String> aboutData;
    private UserData userData = new UserData();

    private ApplicationContext() {
    }

    public static ApplicationContext getInstance() {
        if (instance == null) {
            instance = new ApplicationContext();
        }
        return instance;
    }

    public ResourceContextDelegate newDelegate() {
        return new ResourceContextDelegate();
    }

    public void loadApplicationData() throws Exception {
        this.settings = this.resourceLoader.loadApplicationResource();
    }

    public void loadDataBaseData() throws Exception {
        Connection connection;
        Properties properties = this.resourceLoader.loadProperties(this.settings.getDbConnectionDataPath());
        properties.setProperty("jdbc.connection.url", properties.getProperty("jdbc.connection.url") + this.settings.getUserDataBaseFilePath() + ";ifexists=true");
        DBDataSourceFactory dBDataSourceFactory = DBDataSourceFactory.getInstance();
        dBDataSourceFactory.setConnectionProperties(properties);
        try {
            connection = dBDataSourceFactory.getConnection();
        }
        catch (SQLException sQLException) {
            properties.setProperty("jdbc.connection.url", properties.getProperty("jdbc.connection.url") + this.settings.getUserDataBaseFilePath());
            dBDataSourceFactory.setConnectionProperties(properties);
            connection = dBDataSourceFactory.getConnection();
            Statement statement = connection.createStatement();
            statement.execute(new String(this.loadResourceFromStream("net/sf/amemailchecker/resources/app/create-db.sql")));
            statement.close();
        }
        dBDataSourceFactory.releaseConnection(connection);
    }

    public void loadIconData() throws Exception {
        this.iconBundle = this.resourceLoader.loadPropertiesMap(this.settings.getIconDataPath());
    }

    public void loadLangData() throws Exception {
        this.resourceLoader.loadLangData(this.settings);
    }

    public void loadAboutData() throws Exception {
        this.aboutData = this.resourceLoader.loadPropertiesMap(this.settings.getAboutDataPath());
        this.version = new Version(this.aboutData.get("about.program.version"));
    }

    public void loadUserData() throws Exception {
        new UserDataReader().read(this.settings.getUserDataFilePath(), this.settings.getUserKeyFilePath(), this.userData);
    }

    public void loadUserPreferences() throws IOException {
        new UserPreferencesHelper().loadUserPreferences(this.settings, this.userData);
    }

    public void storeUserData() throws Exception {
        new UserPreferencesHelper().writeUserPreferences(this.settings.getUserPreferencesFilePath(), this.userData);
        new UserDataWriter().write(this.settings.getUserDataFilePath(), this.settings.getUserKeyFilePath(), this.userData);
    }

    public void loadI18NData(int n) {
        Locale locale = this.settings.findLocaleByLangId(n);
        this.i18nBundle = this.resourceLoader.loadI18NBundle(locale);
        this.exceptionCodesBundle = this.resourceLoader.loadExceptionCodesBundle(locale);
    }

    public Map<String, String> getAboutData() {
        return Collections.unmodifiableMap(this.aboutData);
    }

    public String getI18NBundleValue(String string) {
        String string2 = this.i18nBundle.get(string);
        if (string2 == null) {
            string2 = this.aboutData.get(string);
        }
        return string2 != null ? string2 : string;
    }

    public String getImageIcon(String string) {
        String string2 = this.iconBundle.get(string);
        if (string2 == null) {
            string2 = this.aboutData.get(string);
        }
        return string2;
    }

    public String getI18NBundleValue(String string, String string2) {
        Map<String, String> map = this.i18nBundleExt.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return string2;
    }

    public String getImageIcon(String string, String string2) {
        Map<String, String> map = this.iconBundleExt.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return string2;
    }

    public ImageIcon loadImageIcon(String string) {
        String string2 = this.getImageIcon(string);
        if (string2 == null) {
            return null;
        }
        try {
            return new ImageIcon(ImageIO.read(this.getClass().getClassLoader().getResourceAsStream(string2)));
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return null;
        }
    }

    public Map<String, Map<String, String>> getI18nBundleExt() {
        return this.i18nBundleExt;
    }

    public Map<String, Map<String, String>> getIconBundleExt() {
        return this.iconBundleExt;
    }

    public void setI18nBundleExt(String string, Map<String, String> map) {
        this.i18nBundleExt.put(string, map);
    }

    public void setIconBundleExt(String string, Map<String, String> map) {
        this.iconBundleExt.put(string, map);
    }

    public Map<String, String> getExceptionCodesBundle() {
        return this.exceptionCodesBundle;
    }

    public AccountsCache getAccountsCache() {
        return this.userData.getAccountsCache();
    }

    public Object getObject(String string) {
        return this.objectMap.get(string);
    }

    public void setObject(Object object) {
        this.objectMap.put(object.getClass().getName(), object);
    }

    public void removeObject(String string) {
        this.objectMap.remove(string);
    }

    public boolean containsObject(String string) {
        return this.objectMap.containsKey(string);
    }

    public StateContext getStateContext() {
        return this.stateContext;
    }

    public void setStateContext(StateContext stateContext) {
        this.stateContext = stateContext;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Version getVersion() {
        return this.version;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public byte[] loadResourceFromStream(String string) {
        return this.resourceLoader.loadResource(string);
    }

    public String mergeAgainstTemplate(Map<String, String> map, String string) {
        for (String string2 : map.keySet()) {
            string = string.replaceAll(string2, map.get(string2));
        }
        return string;
    }

    private class ResourceContextDelegate
    implements ResourceContext {
        private ResourceContextDelegate() {
        }

        public String getI18NBundleValue(String string) {
            return ApplicationContext.getInstance().getI18NBundleValue(string);
        }

        public String getI18NBundleValue(String string, String string2) {
            return ApplicationContext.getInstance().getI18NBundleValue(string, string2);
        }

        public String getImageIcon(String string) {
            return ApplicationContext.getInstance().getImageIcon(string);
        }

        public String getImageIcon(String string, String string2) {
            return ApplicationContext.getInstance().getImageIcon(string, string2);
        }

        public ImageIcon loadImageIcon(String string) {
            return ApplicationContext.getInstance().loadImageIcon(string);
        }
    }
}

