/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.LookAndFeelManager;
import net.sf.amemailchecker.app.extension.ExtensionInfo;
import net.sf.amemailchecker.app.extension.ExtensionLoader;
import net.sf.amemailchecker.app.extension.ExtensionProvider;
import net.sf.amemailchecker.app.extension.letter.PostalAddresseeCacheExtensionPoint;
import net.sf.amemailchecker.app.logger.SimpleInfoFormatter;
import net.sf.amemailchecker.app.model.PersonIdentity;
import net.sf.amemailchecker.app.model.UserData;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.app.state.StateContext;
import net.sf.amemailchecker.command.impl.app.SynchronizeFolderListCommand;
import net.sf.amemailchecker.command.timer.TimerWrapper;
import net.sf.amemailchecker.db.DataBaseObserver;
import net.sf.amemailchecker.gui.entrypoint.EntryPointMediator;
import net.sf.amemailchecker.gui.messageviewer.extension.MessageViewerExtension;
import net.sf.amemailchecker.gui.notification.mail.MessageOperationsNotificationExtensionPoint;
import net.sf.amemailchecker.gui.notification.splash.SimpleSplashWindow;
import net.sf.amemailchecker.mail.cache.PostalAddresseeCache;
import net.sf.amemailchecker.mail.cache.PostalAddresseeCacheAdapter;
import net.sf.amemailchecker.proxy.ProxyDispatcher;

public class ApplicationLoader {
    private static final Logger logger = Logger.getLogger(ApplicationLoader.class.getName());
    private String path;

    public ApplicationLoader(String string) {
        this.path = string;
    }

    public void load() {
        try {
            this.initLogging();
            ApplicationContext applicationContext = ApplicationContext.getInstance();
            applicationContext.loadApplicationData();
            applicationContext.loadAboutData();
            this.initMacOsSpecific();
            applicationContext.loadLangData();
            applicationContext.loadUserPreferences();
            UserData userData = applicationContext.getUserData();
            LookAndFeelManager.getInstance().setLookAndFeel(userData.getPreferences().getLook());
            SimpleSplashWindow simpleSplashWindow = new SimpleSplashWindow((Image)ImageIO.read(this.getClass().getClassLoader().getResourceAsStream("net/sf/amemailchecker/resources/iconset/icon_splash.png")), true);
            simpleSplashWindow.setLocation();
            simpleSplashWindow.setVisible(true);
            applicationContext.loadDataBaseData();
            applicationContext.loadI18NData(userData.getPreferences().getLanguageCode());
            applicationContext.loadIconData();
            applicationContext.loadUserData();
            ProxyDispatcher.getDispatcher().setProxySettings(userData.getProxySettings());
            TimerWrapper timerWrapper = new TimerWrapper();
            applicationContext.setObject(timerWrapper);
            EntryPointMediator entryPointMediator = new EntryPointMediator();
            StateContext stateContext = new StateContext();
            stateContext.addObserver(entryPointMediator);
            applicationContext.setStateContext(stateContext);
            applicationContext.getAccountsCache().addObserver(stateContext.getAccountCacheObserver());
            applicationContext.getAccountsCache().addObserver(new DataBaseObserver());
            NotificationCache.getInstance().addObserver(stateContext.getNotificationCacheObserver());
            this.loadExtensions(applicationContext.getSettings().getExtensionsDir());
            for (PostalAddresseeCacheExtensionPoint postalAddresseeCacheExtensionPoint : ExtensionProvider.Provider.getPostalAddresseeCacheExtensions()) {
                for (PostalAddresseeCacheAdapter postalAddresseeCacheAdapter : postalAddresseeCacheExtensionPoint.adapters()) {
                    PostalAddresseeCache.Instance.addAdapter(postalAddresseeCacheAdapter);
                }
            }
            PersonIdentity personIdentity = userData.getPersonalData().getPersonIdentity();
            PostalAddresseeCache.Instance.updatePersonal(personIdentity.toString(), userData.getAccounts());
            new SynchronizeFolderListCommand().execute();
            entryPointMediator.initialize(userData.getPreferences().getEntryPointUsed());
            stateContext.stateChanged();
            timerWrapper.startTimer(userData.getPreferences().getMinCheckInterval(), true);
            simpleSplashWindow.setVisible(false);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            System.err.println(exception);
            System.exit(0);
        }
    }

    private void initLogging() throws IOException {
        System.setProperty("hsqldb.reconfig_logging", "false");
        File file = new File(this.path + "log");
        if (!file.exists()) {
            file.mkdirs();
        }
        LogManager logManager = LogManager.getLogManager();
        logManager.readConfiguration(this.getClass().getClassLoader().getResourceAsStream("net/sf/amemailchecker/resources/logging.properties"));
        Enumeration<String> enumeration = logManager.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            for (Handler handler : logManager.getLogger(enumeration.nextElement()).getHandlers()) {
                handler.setFormatter(new SimpleInfoFormatter());
            }
        }
    }

    private void loadExtensions(String string) {
        logger.info("Loading of extensions started");
        ExtensionInfo extensionInfo = new ExtensionInfo();
        extensionInfo.setExtension(new MessageViewerExtension());
        extensionInfo.setName("Message Viewer");
        extensionInfo.setSmooth(true);
        extensionInfo.setClassLoader(this.getClass().getClassLoader());
        ExtensionProvider.Provider.registerExtension(extensionInfo);
        ExtensionProvider.Provider.getNotificationExtensions().add(new MessageOperationsNotificationExtensionPoint());
        ExtensionLoader extensionLoader = new ExtensionLoader();
        List<ExtensionInfo> list = extensionLoader.load(this.path + string);
        for (ExtensionInfo extensionInfo2 : list) {
            ExtensionProvider.Provider.registerExtension(extensionInfo2);
        }
        logger.info("Loading of extensions finished");
    }

    private void initMacOsSpecific() {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", ApplicationContext.getInstance().getAboutData().get("about.program.name"));
    }
}

