/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import net.sf.amemailchecker.gui.component.button.MetalDropDownMenuButtonUI;

public final class LookAndFeelManager {
    private static LookAndFeelManager instance = new LookAndFeelManager();

    public static LookAndFeelManager getInstance() {
        return instance;
    }

    private LookAndFeelManager() {
    }

    public void setLookAndFeel(int n) throws Exception {
        switch (n) {
            case 0: {
                this.setDefaultLookAndFeel();
                break;
            }
            case 1: {
                this.setCrossPlatformLookAndFeel();
                break;
            }
            case 2: {
                this.setNativeLookAndFeel();
            }
        }
    }

    public void setDefaultLookAndFeel() throws Exception {
        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DefaultTheme());
        PlasticLookAndFeel.setTabStyle((String)"metal");
        UIManager.put("jgoodies.useNarrowButtons", Boolean.FALSE);
        UIManager.put("ToolTip.background", new ColorUIResource(Color.WHITE));
        UIManager.setLookAndFeel(PlasticXPLookAndFeel.class.getName());
    }

    public void setCrossPlatformLookAndFeel() throws Exception {
        UIManager.put("DropDownMenuButtonUI", MetalDropDownMenuButtonUI.class.getName());
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    }

    public void setNativeLookAndFeel() throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public static enum Look {
        DEFAULT(0, "label.look.default"),
        CROSS_PLATFORM(1, "label.look.cross"),
        NATIVE(2, "label.look.native");

        private int id;
        private String titleKey;

        private Look(int n2, String string2) {
            this.id = n2;
            this.titleKey = string2;
        }

        public int getId() {
            return this.id;
        }

        public String getTitleKey() {
            return this.titleKey;
        }
    }

    private class DefaultTheme
    extends ExperienceBlue {
        private DefaultTheme() {
        }

        protected ColorUIResource getSecondary3() {
            return new ColorUIResource(237, 235, 232);
        }

        protected ColorUIResource getPrimary2() {
            return super.getPrimary1();
        }

        protected ColorUIResource getPrimary3() {
            return this.getPrimary1();
        }

        public ColorUIResource getToggleButtonCheckColor() {
            return super.getPrimary1();
        }

        public ColorUIResource getFocusColor() {
            return new ColorUIResource(new Color(188, 210, 230));
        }
    }
}

