/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.model.Language;
import net.sf.amemailchecker.app.model.Settings;

public class ResourceLoader {
    public static final String RESOURCE_PATH = "net/sf/amemailchecker/resources/";
    public static final String RESOURCE_BUNDLE_BASE_NAME = "AmeMailChecker";
    public static final String I18N_RESOURCE_PATH = "net/sf/amemailchecker/resources/i18n/application";
    public static final String I18N_RESOURCE_EXCEPTION_PATH = "net/sf/amemailchecker/resources/i18n/exception-codes";
    private static Logger logger = Logger.getLogger(ResourceLoader.class.getName());

    public Settings loadApplicationResource() {
        Properties properties = new Properties();
        try {
            properties = this.loadProperties("net/sf/amemailchecker/resources/AmeMailChecker.properties");
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Cannot load application resources!", iOException);
            System.exit(0);
        }
        Settings settings = new Settings();
        settings.setUserDataDir(properties.getProperty("userDataDir"));
        settings.setUserDataFile(properties.getProperty("userDataFile"));
        settings.setUserPreferencesFile(properties.getProperty("userPreferencesFile"));
        settings.setUserKeyFile(properties.getProperty("userKeyFile"));
        settings.setUserPreferencesFileDefault(properties.getProperty("userPreferencesFileDefault"));
        settings.setExtensionsDir(properties.getProperty("extensionsDir"));
        settings.setExtensionsDataDir(properties.getProperty("extensionsDataDir"));
        settings.setUserDownloadsDirDefault(properties.getProperty("userDownloadsDirDefault"));
        settings.setUserDataBaseFile(properties.getProperty("userDataBaseFile"));
        settings.setIconDataPath(properties.getProperty("icon.data"));
        settings.setLangDataPath(properties.getProperty("lang.data"));
        settings.setAboutDataPath(properties.getProperty("about.data"));
        settings.setDbConnectionDataPath(properties.getProperty("db.connection.data"));
        return settings;
    }

    public void loadLangData(Settings settings) throws Exception {
        Map<String, String> map = this.loadPropertiesMap(settings.getLangDataPath());
        ArrayList<Language> arrayList = new ArrayList<Language>();
        for (String string : map.keySet()) {
            Language language = new Language();
            language.setLabel(map.get(string));
            String[] stringArray = string.split("[.]");
            language.setCode(Integer.parseInt(stringArray[0]));
            language.setLocaleCode(stringArray[1]);
            arrayList.add(language);
        }
        settings.setLanguageData(arrayList);
    }

    public Map<String, String> loadI18NBundle(Locale locale) {
        return this.loadI18NResource(I18N_RESOURCE_PATH, locale, this.getClass().getClassLoader());
    }

    public Map<String, String> loadExceptionCodesBundle(Locale locale) {
        return this.loadI18NResource(I18N_RESOURCE_EXCEPTION_PATH, locale, this.getClass().getClassLoader());
    }

    public Map<String, String> loadI18NResource(String string, Locale locale, ClassLoader classLoader) {
        return this.loadInMap(this.loadBundle(string, locale, classLoader));
    }

    private Map<String, String> loadInMap(ResourceBundle resourceBundle) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : resourceBundle.keySet()) {
            hashMap.put(string, resourceBundle.getString(string));
        }
        return hashMap;
    }

    private ResourceBundle loadBundle(String string, Locale locale, ClassLoader classLoader) {
        try {
            return ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            return ResourceBundle.getBundle(string, Locale.ROOT);
        }
    }

    public HashMap<String, String> parseKeyValues(String string) {
        String[] stringArray = string.split("[~]");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split("[=]");
            hashMap.put(stringArray2[0].trim(), stringArray2[1].trim());
        }
        return hashMap;
    }

    public byte[] loadResource(String string) {
        byte[] byArray;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        try {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Cannot load application resource by path" + string, iOException);
            return new byte[0];
        }
        return byArray;
    }

    public Properties loadProperties(String string) throws IOException {
        return this.loadProperties(string, this.getClass().getClassLoader());
    }

    public Properties loadProperties(String string, ClassLoader classLoader) throws IOException {
        Properties properties = new Properties();
        properties.load(classLoader.getResourceAsStream(string));
        return properties;
    }

    public Map<String, String> loadPropertiesMap(String string) throws IOException {
        Properties properties = this.loadProperties(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : properties.stringPropertyNames()) {
            hashMap.put(string2, properties.getProperty(string2));
        }
        return hashMap;
    }
}

