/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app;

public class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int revision;

    public Version() {
    }

    public Version(int n, int n2, int n3) {
        this.major = n;
        this.minor = n2;
        this.revision = n3;
    }

    public Version(String string) {
        String[] stringArray = string.split("[.]");
        this.major = Integer.parseInt(stringArray[0]);
        this.minor = Integer.parseInt(stringArray[1]);
        this.revision = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 0;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int n) {
        this.revision = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        return this.revision == version.revision;
    }

    public int hashCode() {
        int n = this.major;
        n = 31 * n + this.minor;
        n = 31 * n + this.revision;
        return n;
    }

    @Override
    public int compareTo(Version version) {
        int n;
        if (this.equals(version)) {
            return 0;
        }
        int n2 = this.major == version.major ? 0 : (n = this.major > version.major ? 1 : -1);
        if (n == 0) {
            int n3 = this.minor == version.minor ? 0 : (n = this.minor > version.minor ? 1 : -1);
        }
        if (n == 0) {
            n = this.revision == version.revision ? 0 : (this.revision > version.revision ? 1 : -1);
        }
        return n;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.revision;
    }
}

