/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.account;

import net.sf.amemailchecker.app.account.AccountServerBean;
import net.sf.amemailchecker.app.model.UserCredentials;
import net.sf.amemailchecker.mail.Protocol;
import net.sf.amemailchecker.mail.impl.mailbox.MailBoxImpl;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.MailBox;
import net.sf.amemailchecker.mail.model.MailBoxPreferences;

public class AccountBean
implements Account {
    private String uuid;
    private String title;
    private String emailAddress;
    private boolean active = true;
    private AccountServerBean ingoingServer;
    private AccountServerBean outgoingServer;
    private UserCredentials userCredentials;
    private MailBox mailBox;
    private MailBoxPreferences mailBoxPreferences;

    public AccountBean() {
    }

    public AccountBean(String string) {
        this.uuid = string;
    }

    public AccountBean(AccountBean accountBean) {
        this(accountBean.getUuid());
        this.setAccountBean(accountBean);
    }

    public void setAccountBean(AccountBean accountBean) {
        this.title = accountBean.getTitle();
        this.emailAddress = accountBean.getEmailAddress();
        this.active = accountBean.isActive();
        this.userCredentials = new UserCredentials(accountBean.getUserCredentials());
        this.ingoingServer = new AccountServerBean(accountBean.getIngoingServer());
        this.outgoingServer = new AccountServerBean(accountBean.getOutgoingServer());
        this.mailBox = new MailBoxImpl(accountBean.getMailBox());
        this.mailBoxPreferences = new MailBoxPreferences(accountBean.getMailBoxPreferences());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String string) {
        this.uuid = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String string) {
        this.emailAddress = string;
    }

    public MailBoxPreferences getMailBoxPreferences() {
        return this.mailBoxPreferences;
    }

    public void setMailBoxPreferences(MailBoxPreferences mailBoxPreferences) {
        this.mailBoxPreferences = mailBoxPreferences;
    }

    public AccountServerBean getIngoingServer() {
        if (this.ingoingServer == null) {
            this.ingoingServer = new AccountServerBean();
        }
        return this.ingoingServer;
    }

    public void setIngoingServer(AccountServerBean accountServerBean) {
        this.ingoingServer = accountServerBean;
    }

    public AccountServerBean getOutgoingServer() {
        if (this.outgoingServer == null) {
            this.outgoingServer = new AccountServerBean();
        }
        return this.outgoingServer;
    }

    public void setOutgoingServer(AccountServerBean accountServerBean) {
        this.outgoingServer = accountServerBean;
    }

    public UserCredentials getUserCredentials() {
        if (this.userCredentials == null) {
            this.userCredentials = new UserCredentials();
        }
        return this.userCredentials;
    }

    public void setUserCredentials(UserCredentials userCredentials) {
        this.userCredentials = userCredentials;
    }

    public MailBox getMailBox() {
        if (this.mailBox == null) {
            this.mailBox = new MailBoxImpl();
        }
        return this.mailBox;
    }

    public void setMailBox(MailBox mailBox) {
        this.mailBox = mailBox;
    }

    public String toString() {
        return this.title;
    }

    public Protocol getIncomingServerProtocol() {
        return Protocol.getById((int)this.ingoingServer.getServerSettings().getProtocolType());
    }
}

