/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.account;

import net.sf.amemailchecker.app.model.ServerSettings;
import net.sf.amemailchecker.mail.Protocol;

public class AccountServerBean {
    private int connectionSecurity = Protocol.NONE.getId();
    private ServerSettings serverSettings;

    public AccountServerBean() {
    }

    public AccountServerBean(AccountServerBean accountServerBean) {
        this.connectionSecurity = accountServerBean.getConnectionSecurity();
        this.serverSettings = new ServerSettings(accountServerBean.getServerSettings());
    }

    public int getConnectionSecurity() {
        return this.connectionSecurity;
    }

    public void setConnectionSecurity(int n) {
        this.connectionSecurity = n;
    }

    public boolean isUseSSL() {
        return Protocol.getById((int)this.connectionSecurity).equals((Object)Protocol.SSL);
    }

    public boolean isUseStartTls() {
        return Protocol.getById((int)this.connectionSecurity).equals((Object)Protocol.TLS);
    }

    public int getPort() {
        if (this.serverSettings.isUseDefaultPort()) {
            return Protocol.getById((int)this.serverSettings.getProtocolType()).getPortDefault(Protocol.getById((int)this.connectionSecurity));
        }
        return this.serverSettings.getPort();
    }

    public ServerSettings getServerSettings() {
        if (this.serverSettings == null) {
            this.serverSettings = new ServerSettings();
        }
        return this.serverSettings;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }
}

