/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.account;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.app.account.AccountCacheEvent;
import net.sf.amemailchecker.gui.component.list.HistoryListModelObservable;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.util.GenericObservable;

public class AccountsCache
extends GenericObservable<AccountCacheEvent>
implements Observer {
    private TreeMap<String, Account> accounts = new TreeMap();

    public List<Account> updateDeleted(Collection<Account> collection) {
        ArrayList<Account> arrayList = new ArrayList<Account>();
        for (Account account : collection) {
            arrayList.add(this.delete(account.getUuid()));
        }
        return arrayList;
    }

    public void updateEdited(Collection<Account> collection) {
        for (Account account : collection) {
            Account account2 = this.accounts.get(account.getUuid());
            if (account2 != null) {
                ((AccountBean)account2).setAccountBean((AccountBean)account);
                this.fireObserverUpdate(AccountCacheEvent.AccountCacheEventType.EDIT, account);
                continue;
            }
            this.accounts.put(account.getUuid(), account);
            this.fireObserverUpdate(AccountCacheEvent.AccountCacheEventType.INSERT, account);
        }
    }

    public List<Account> updateStatuses(Map<Account, Boolean> map) {
        ArrayList<Account> arrayList = new ArrayList<Account>();
        for (Account account : map.keySet()) {
            Account account2 = this.accounts.get(account.getUuid());
            ((AccountBean)account2).setActive(map.get(account));
            arrayList.add(account2);
        }
        this.fireObserverUpdate(AccountCacheEvent.AccountCacheEventType.STATUS, arrayList.toArray(new Account[arrayList.size()]));
        return arrayList;
    }

    public Account delete(String string) {
        Account account = this.accounts.remove(string);
        this.fireObserverUpdate(AccountCacheEvent.AccountCacheEventType.DELETE, account);
        return account;
    }

    public Collection<Account> getAccounts() {
        return this.accounts.values();
    }

    public void setAccounts(Collection<Account> collection) {
        this.accounts.clear();
        for (Account account : collection) {
            this.accounts.put(account.getUuid(), account);
        }
    }

    public boolean hasActive() {
        for (Account account : this.accounts.values()) {
            if (!account.isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.accounts.isEmpty();
    }

    public Account getByUuid(String string) {
        for (Account account : this.accounts.values()) {
            if (!account.getUuid().equals(string)) continue;
            return account;
        }
        return null;
    }

    public Account getByTitle(String string) {
        for (Account account : this.accounts.values()) {
            if (!account.getTitle().equals(string)) continue;
            return account;
        }
        return null;
    }

    public Collection<Account> getActiveAccounts() {
        ArrayList<Account> arrayList = new ArrayList<Account>();
        for (Account account : this.accounts.values()) {
            if (!account.isActive()) continue;
            arrayList.add(account);
        }
        return arrayList;
    }

    public String[] getAccountNames(boolean bl) {
        Collection<Account> collection = bl ? this.getActiveAccounts() : this.accounts.values();
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (Account account : collection) {
            stringArray[n] = account.getTitle();
            ++n;
        }
        return stringArray;
    }

    @Override
    public void update(Observable observable, Object object) {
        Collection collection;
        Map map;
        HistoryListModelObservable historyListModelObservable = (HistoryListModelObservable)observable;
        Collection collection2 = historyListModelObservable.getEdited();
        if (collection2.size() > 0) {
            this.updateEdited(collection2);
        }
        if ((map = historyListModelObservable.getStatuses(true)).size() > 0) {
            this.updateStatuses(map);
        }
        if ((collection = historyListModelObservable.getDeleted()).size() > 0) {
            this.updateDeleted(collection);
        }
    }

    private void fireObserverUpdate(AccountCacheEvent.AccountCacheEventType accountCacheEventType, Account ... accountArray) {
        if (accountArray != null && accountArray.length > 0) {
            this.fireObserverUpdate(new AccountCacheEvent(accountCacheEventType, accountArray));
        }
    }

    public void fireObserverUpdate(AccountCacheEvent accountCacheEvent) {
        this.setChanged();
        this.notifyObservers(accountCacheEvent);
    }
}

