/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.account;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.sf.amemailchecker.app.DataNodeName;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.app.account.AccountServerBean;
import net.sf.amemailchecker.app.model.io.AppBaseSettingsReader;
import net.sf.amemailchecker.mail.Protocol;
import net.sf.amemailchecker.mail.impl.mailbox.FolderAttribute;
import net.sf.amemailchecker.mail.impl.mailbox.IMAPFolder;
import net.sf.amemailchecker.mail.impl.mailbox.MailBoxImpl;
import net.sf.amemailchecker.mail.impl.mailbox.POP3Folder;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.MailBoxPreferences;
import net.sf.amemailchecker.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AccountsReader
extends AppBaseSettingsReader {
    public Collection<Account> read(Document document, File file) throws Exception {
        ArrayList<Account> arrayList = new ArrayList<Account>();
        NodeList nodeList = document.getElementsByTagName("account");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            AccountBean accountBean = new AccountBean();
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("uuid");
            accountBean.setUuid(StringUtil.isNullOrEmpty((String)string) ? UUID.randomUUID().toString() : string);
            accountBean.setTitle(element.getElementsByTagName("name").item(0).getTextContent());
            accountBean.setEmailAddress(element.getElementsByTagName("e-mail").item(0).getTextContent());
            accountBean.setUserCredentials(this.readUserCredentials(element, file));
            accountBean.setActive(Boolean.parseBoolean(element.getElementsByTagName("active").item(0).getTextContent()));
            accountBean.setIngoingServer(this.readServerElement((Element)element.getElementsByTagName("ingoing-server").item(0)));
            accountBean.setOutgoingServer(this.readServerElement((Element)element.getElementsByTagName("outgoing-server").item(0)));
            NodeList nodeList2 = element.getElementsByTagName("mailbox");
            if (nodeList2.getLength() > 0) {
                Element element2 = (Element)nodeList2.item(0);
                accountBean.setMailBox(this.readMailBoxElement(element2, Protocol.getById((int)accountBean.getIngoingServer().getServerSettings().getProtocolType())));
                accountBean.setMailBoxPreferences(this.readMailBoxPreferences(element2));
            }
            arrayList.add(accountBean);
        }
        return arrayList;
    }

    private AccountServerBean readServerElement(Element element) {
        AccountServerBean accountServerBean = new AccountServerBean();
        accountServerBean.setServerSettings(super.readServerSettings(element));
        accountServerBean.setConnectionSecurity(Integer.parseInt(element.getElementsByTagName("conn-security").item(0).getTextContent()));
        return accountServerBean;
    }

    private MailBoxPreferences readMailBoxPreferences(Element element) {
        MailBoxPreferences mailBoxPreferences = new MailBoxPreferences();
        NodeList nodeList = element.getElementsByTagName(DataNodeName.DOWNLOAD_LETTER_BODY.label());
        if (nodeList.getLength() > 0) {
            mailBoxPreferences.setDownloadCompleteLetter(Boolean.valueOf(nodeList.item(0).getTextContent()).booleanValue());
        }
        if ((nodeList = element.getElementsByTagName(DataNodeName.SYNC_FOLDERS_AT_STARTUP.label())).getLength() > 0) {
            mailBoxPreferences.setSynchronizeFoldersAtStartup(Boolean.valueOf(nodeList.item(0).getTextContent()).booleanValue());
        }
        return mailBoxPreferences;
    }

    private MailBoxImpl readMailBoxElement(Element element, Protocol protocol) {
        MailBoxImpl mailBoxImpl = new MailBoxImpl();
        if (protocol.equals((Object)Protocol.POP3)) {
            POP3Folder pOP3Folder = new POP3Folder();
            pOP3Folder.setEnabled(true);
            mailBoxImpl.getFolders().add(pOP3Folder);
            return mailBoxImpl;
        }
        NodeList nodeList = element.getElementsByTagName("folder");
        if (nodeList.getLength() <= 0) {
            IMAPFolder iMAPFolder = new IMAPFolder();
            iMAPFolder.setName("INBOX");
            iMAPFolder.setLabel("INBOX");
            iMAPFolder.setEnabled(true);
            mailBoxImpl.getFolders().add(iMAPFolder);
            return mailBoxImpl;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Element element2 = (Element)nodeList.item(i);
            IMAPFolder iMAPFolder = new IMAPFolder();
            iMAPFolder.setName(element2.getAttribute("name"));
            iMAPFolder.setLabel(element2.getAttribute("label"));
            iMAPFolder.setDelimiter(element2.getAttribute("delimiter"));
            iMAPFolder.setEnabled(Boolean.valueOf(element2.getAttribute("enabled")));
            if (!Boolean.valueOf(element2.getAttribute("selectable")).booleanValue()) {
                iMAPFolder.addAttribute(FolderAttribute.Noselect.name());
            }
            if (!Boolean.valueOf(element2.getAttribute("children-allowed")).booleanValue()) {
                iMAPFolder.addAttribute(FolderAttribute.Noinferiors.name());
            }
            if (StringUtil.isNullOrEmpty((String)(string = element2.getAttribute("parent")))) {
                mailBoxImpl.getFolders().add(iMAPFolder);
                continue;
            }
            Folder folder = this.parent(string, mailBoxImpl.getFolders());
            folder.getChildren().add(iMAPFolder);
        }
        return mailBoxImpl;
    }

    private Folder parent(String string, Collection<Folder> collection) {
        for (Folder folder : collection) {
            if (folder.getName().equals(string)) {
                return folder;
            }
            if ((folder = this.parent(string, folder.getChildren())) == null) continue;
            return folder;
        }
        return null;
    }
}

