/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.account;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.amemailchecker.app.DataNodeName;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.app.account.AccountServerBean;
import net.sf.amemailchecker.app.model.io.AppBaseSettingsWriter;
import net.sf.amemailchecker.mail.Protocol;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.MailBox;
import net.sf.amemailchecker.mail.model.MailBoxPreferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AccountsWriter
extends AppBaseSettingsWriter {
    public void write(Document document, Collection<Account> collection, File file) throws Exception {
        Element element = document.createElement("accounts");
        for (Account account : collection) {
            AccountBean accountBean = (AccountBean)account;
            Element element2 = document.createElement("account");
            element2.setAttribute("uuid", accountBean.getUuid());
            this.appendChild("name", accountBean.getTitle(), element2, document);
            this.createUserCredentials(accountBean.getUserCredentials(), element2, document, file);
            this.appendChild("e-mail", accountBean.getEmailAddress(), element2, document);
            this.appendChild("active", Boolean.toString(accountBean.isActive()), element2, document);
            element2.appendChild(this.createServerElement("ingoing-server", accountBean.getIngoingServer(), document));
            element2.appendChild(this.createServerElement("outgoing-server", accountBean.getOutgoingServer(), document));
            element2.appendChild(this.createMailBoxElement(accountBean.getMailBox(), accountBean.getMailBoxPreferences(), document, Protocol.getById((int)accountBean.getIngoingServer().getServerSettings().getProtocolType())));
            element.appendChild(element2);
        }
        document.getDocumentElement().appendChild(element);
    }

    private Element createServerElement(String string, AccountServerBean accountServerBean, Document document) {
        Element element = super.createServerElement(string, accountServerBean.getServerSettings(), document);
        this.appendChild("conn-security", Integer.toString(accountServerBean.getConnectionSecurity()), element, document);
        return element;
    }

    private Element createMailBoxElement(MailBox mailBox, MailBoxPreferences mailBoxPreferences, Document document, Protocol protocol) {
        Element element = document.createElement("mailbox");
        Element element2 = document.createElement("settings");
        this.appendChild(DataNodeName.DOWNLOAD_LETTER_BODY.label(), Boolean.toString(mailBoxPreferences.isDownloadCompleteLetter()), element2, document);
        this.appendChild(DataNodeName.SYNC_FOLDERS_AT_STARTUP.label(), Boolean.toString(mailBoxPreferences.isSynchronizeFoldersAtStartup()), element2, document);
        if (!protocol.equals((Object)Protocol.POP3)) {
            Element element3 = document.createElement("folders");
            ArrayList<Element> arrayList = new ArrayList<Element>();
            this.createFolderElements(mailBox.getFolders(), null, arrayList, document);
            for (Element element4 : arrayList) {
                element3.appendChild(element4);
            }
            element.appendChild(element3);
        }
        element.appendChild(element2);
        return element;
    }

    private void createFolderElements(Collection<Folder> collection, Folder folder, Collection<Element> collection2, Document document) {
        for (Folder folder2 : collection) {
            Element element = this.createFolderElement(folder2, folder, document);
            collection2.add(element);
            this.createFolderElements(folder2.getChildren(), folder2, collection2, document);
        }
    }

    private Element createFolderElement(Folder folder, Folder folder2, Document document) {
        Element element = document.createElement("folder");
        element.setAttribute("name", folder.getName());
        element.setAttribute("label", folder.getLabel());
        element.setAttribute("selectable", Boolean.toString(folder.isSelectable()));
        element.setAttribute("children-allowed", Boolean.toString(folder.isChildrenAllowed()));
        element.setAttribute("delimiter", folder.getDelimiter());
        if (folder2 != null) {
            element.setAttribute("parent", folder2.getName());
        }
        element.setAttribute("enabled", Boolean.toString(folder.isEnabled()));
        return element;
    }
}

