/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.extension;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceLoader;
import net.sf.amemailchecker.app.Version;
import net.sf.amemailchecker.app.extension.Extension;
import net.sf.amemailchecker.app.extension.ExtensionInfo;
import net.sf.amemailchecker.app.extension.ExtensionInfoProperty;
import net.sf.amemailchecker.app.extension.InvalidExtensionManifestException;
import net.sf.amemailchecker.util.StringUtil;

public class ExtensionLoader {
    private static final Logger logger = Logger.getLogger(ExtensionLoader.class.getName());

    public List<ExtensionInfo> load(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".jar");
            }
        });
        LinkedList<ExtensionInfo> linkedList = new LinkedList<ExtensionInfo>();
        for (File file2 : fileArray) {
            ExtensionInfo extensionInfo;
            try {
                extensionInfo = this.load(file2);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, exception.getMessage(), exception);
                continue;
            }
            linkedList.add(extensionInfo);
            this.loadBundleData(extensionInfo);
        }
        return linkedList;
    }

    ExtensionInfo load(File file) throws Exception {
        JarFile jarFile = new JarFile(file);
        Manifest manifest = jarFile.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        String string = attributes.getValue(ExtensionInfoProperty.CLASS.key());
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new InvalidExtensionManifestException("Attribute [ " + ExtensionInfoProperty.CLASS.key() + " ] isn't found");
        }
        String string2 = attributes.getValue(ExtensionInfoProperty.NAME.key());
        if (StringUtil.isNullOrEmpty((String)string2)) {
            throw new InvalidExtensionManifestException("Attribute [ " + ExtensionInfoProperty.NAME.key() + " ] isn't found");
        }
        Version version = new Version(attributes.getValue(ExtensionInfoProperty.MIN_REQUIRED_APP_VERSION.key()));
        Version version2 = ApplicationContext.getInstance().getVersion();
        if (version2.compareTo(version) == -1) {
            throw new RuntimeException("Extension [ " + string2 + " ] requires app version at least [" + version + "] when current version is [" + version2 + "]");
        }
        URL uRL = file.toURI().toURL();
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, this.getClass().getClassLoader().getParent());
        Class<?> clazz = uRLClassLoader.loadClass(string);
        if (!Extension.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("Main class for extension [ " + string2 + " ] is not supported type");
        }
        Extension extension = (Extension)clazz.newInstance();
        ExtensionInfo extensionInfo = new ExtensionInfo();
        extensionInfo.setClassLoader(uRLClassLoader);
        extensionInfo.setExtension(extension);
        extensionInfo.setName(string2);
        extensionInfo.setAuthor(attributes.getValue(ExtensionInfoProperty.AUTHOR.key()));
        extensionInfo.setVersion(attributes.getValue(ExtensionInfoProperty.VERSION.key()));
        extensionInfo.setEmail(attributes.getValue(ExtensionInfoProperty.EMAIL.key()));
        extensionInfo.setHomePage(attributes.getValue(ExtensionInfoProperty.HOME_PAGE.key()));
        extensionInfo.setI18nBundlePath(attributes.getValue(ExtensionInfoProperty.I18N_BUNDLE.key()));
        extensionInfo.setIconBundlePath(attributes.getValue(ExtensionInfoProperty.ICON_BUNDLE.key()));
        extensionInfo.setDescriptionBundleKey(attributes.getValue(ExtensionInfoProperty.DESCRIPTION_KEY.key()));
        return extensionInfo;
    }

    public void loadBundleData(ExtensionInfo extensionInfo) {
        Map<String, String> map;
        ResourceLoader resourceLoader = new ResourceLoader();
        String string = extensionInfo.getIconBundlePath();
        String string2 = extensionInfo.getI18nBundlePath();
        if (!StringUtil.isNullOrEmpty((String)string)) {
            try {
                string = resourceLoader.loadProperties(string, extensionInfo.getClassLoader()).getProperty("icon.data");
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Unable to load icon bundle for extension [ " + extensionInfo.getName() + " ]", exception);
                string = null;
            }
            if (!StringUtil.isNullOrEmpty((String)string)) {
                map = resourceLoader.parseKeyValues(string);
                ApplicationContext.getInstance().setIconBundleExt(extensionInfo.getName(), map);
            }
        }
        if (!StringUtil.isNullOrEmpty((String)string2)) {
            map = resourceLoader.loadI18NResource(string2, ApplicationContext.getInstance().getSettings().findLocaleByLangId(ApplicationContext.getInstance().getUserData().getPreferences().getLanguageCode()), extensionInfo.getClassLoader());
            ApplicationContext.getInstance().setI18nBundleExt(extensionInfo.getName(), map);
        }
    }

    public void loadBundleData(List<ExtensionInfo> list) {
        for (ExtensionInfo extensionInfo : list) {
            this.loadBundleData(extensionInfo);
        }
    }
}

