/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.extension;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.DefaultExtensionContext;
import net.sf.amemailchecker.app.extension.EntryPointExtensionPoint;
import net.sf.amemailchecker.app.extension.ExtensionContext;
import net.sf.amemailchecker.app.extension.ExtensionInfo;
import net.sf.amemailchecker.app.extension.ExtensionPoint;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsActionExtensionPoint;
import net.sf.amemailchecker.app.extension.letter.PostalAddresseeCacheExtensionPoint;
import net.sf.amemailchecker.app.extension.letter.RecipientDocumentExtensionPoint;
import net.sf.amemailchecker.app.extension.notification.NotificationExtensionPoint;
import net.sf.amemailchecker.app.extension.viewer.ViewerExtensionPoint;

public enum ExtensionProvider {
    Provider;

    private static final Logger logger;
    private List<NotificationExtensionPoint> notificationExtensions;
    private List<EntryPointExtensionPoint> entryPointExtensions;
    private List<LetterDetailsActionExtensionPoint> letterDetailsActionExtensions;
    private List<PostalAddresseeCacheExtensionPoint> postalAddresseeCacheExtensions;
    private List<ViewerExtensionPoint> viewerExtensionPoints;
    private List<RecipientDocumentExtensionPoint> recipientDocumentPoints;
    private List<ExtensionInfo> extensions = new ArrayList<ExtensionInfo>();

    private ExtensionProvider() {
        this.notificationExtensions = new LinkedList<NotificationExtensionPoint>();
        this.entryPointExtensions = new LinkedList<EntryPointExtensionPoint>();
        this.letterDetailsActionExtensions = new LinkedList<LetterDetailsActionExtensionPoint>();
        this.postalAddresseeCacheExtensions = new LinkedList<PostalAddresseeCacheExtensionPoint>();
        this.viewerExtensionPoints = new LinkedList<ViewerExtensionPoint>();
        this.recipientDocumentPoints = new ArrayList<RecipientDocumentExtensionPoint>();
    }

    public void registerExtension(ExtensionInfo extensionInfo) {
        String string;
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        DefaultExtensionContext defaultExtensionContext = new DefaultExtensionContext();
        if (!extensionInfo.isSmooth()) {
            string = applicationContext.getSettings().getExtensionDataDirPath(extensionInfo.getName());
            File file = new File(string);
            file.mkdirs();
            defaultExtensionContext.setExtensionDataDir(string);
        }
        defaultExtensionContext.setResourceContext(ApplicationContext.getInstance().newDelegate());
        string = extensionInfo.getExtension();
        try {
            string.startup((ExtensionContext)defaultExtensionContext);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Unable to load extension with name [ " + extensionInfo.getName() + " ]", exception);
            applicationContext.getI18nBundleExt().remove(extensionInfo.getName());
            applicationContext.getIconBundleExt().remove(extensionInfo.getName());
            return;
        }
        boolean bl = this.sortPoints(extensionInfo);
        if (bl) {
            this.extensions.add(extensionInfo);
            if (!extensionInfo.isSmooth()) {
                logger.info("Extension [ " + extensionInfo.getName() + " ] successfully registered");
            }
        } else {
            logger.log(Level.SEVERE, "All of extension points for extension [ " + extensionInfo.getName() + " ]" + "are failed to load. The extension will not be registered.");
            applicationContext.getI18nBundleExt().remove(extensionInfo.getName());
            applicationContext.getIconBundleExt().remove(extensionInfo.getName());
        }
    }

    private boolean sortPoints(ExtensionInfo extensionInfo) {
        ExtensionPoint[] extensionPointArray = extensionInfo.getExtension().extensionPoints();
        if (extensionPointArray == null) {
            logger.log(Level.SEVERE, "Extension [ " + extensionInfo.getName() + " ] does not contain any points");
            return false;
        }
        int n = 0;
        for (ExtensionPoint extensionPoint : extensionPointArray) {
            if (extensionPoint instanceof NotificationExtensionPoint) {
                this.notificationExtensions.add((NotificationExtensionPoint)extensionPoint);
                continue;
            }
            if (extensionPoint instanceof EntryPointExtensionPoint) {
                this.entryPointExtensions.add((EntryPointExtensionPoint)extensionPoint);
                continue;
            }
            if (extensionPoint instanceof LetterDetailsActionExtensionPoint) {
                this.letterDetailsActionExtensions.add((LetterDetailsActionExtensionPoint)extensionPoint);
                continue;
            }
            if (extensionPoint instanceof PostalAddresseeCacheExtensionPoint) {
                this.postalAddresseeCacheExtensions.add((PostalAddresseeCacheExtensionPoint)extensionPoint);
                continue;
            }
            if (extensionPoint instanceof ViewerExtensionPoint) {
                this.viewerExtensionPoints.add((ViewerExtensionPoint)extensionPoint);
                continue;
            }
            if (extensionPoint instanceof RecipientDocumentExtensionPoint) {
                this.recipientDocumentPoints.add((RecipientDocumentExtensionPoint)extensionPoint);
                continue;
            }
            logger.log(Level.SEVERE, "Extension point for extension [ " + extensionInfo.getName() + " ]" + "with class [" + extensionPoint.getClass().getName() + "] is not supported type");
            ++n;
        }
        return n != extensionPointArray.length;
    }

    public ExtensionPoint findPoint(Class clazz) {
        for (ExtensionInfo extensionInfo : this.extensions) {
            ExtensionPoint[] extensionPointArray = extensionInfo.getExtension().extensionPoints();
            if (extensionPointArray == null) continue;
            for (ExtensionPoint extensionPoint : extensionPointArray) {
                if (!extensionPoint.getClass().equals(clazz)) continue;
                return extensionPoint;
            }
        }
        return null;
    }

    public List<EntryPointExtensionPoint> getEntryPointExtensions() {
        return this.entryPointExtensions;
    }

    public List<NotificationExtensionPoint> getNotificationExtensions() {
        return this.notificationExtensions;
    }

    public List<LetterDetailsActionExtensionPoint> getLetterDetailsActionExtensions() {
        return this.letterDetailsActionExtensions;
    }

    public List<PostalAddresseeCacheExtensionPoint> getPostalAddresseeCacheExtensions() {
        return this.postalAddresseeCacheExtensions;
    }

    public List<ViewerExtensionPoint> getViewerExtensionPoints() {
        return this.viewerExtensionPoints;
    }

    public List<RecipientDocumentExtensionPoint> getRecipientDocumentPoints() {
        return this.recipientDocumentPoints;
    }

    public List<ExtensionInfo> getExtensions() {
        return this.extensions;
    }

    static {
        logger = Logger.getLogger(ExtensionProvider.class.getName());
    }
}

