/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.exception.ApplicationException;
import net.sf.amemailchecker.app.exception.ExceptionCode;

public class SimpleInfoFormatter
extends SimpleFormatter {
    private static final DateFormat dateFormatter = new SimpleDateFormat("yy/dd/MM kk:mm:ss");

    @Override
    public synchronized String format(LogRecord logRecord) {
        if (!logRecord.getLevel().equals(Level.INFO)) {
            return super.format(logRecord);
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendHeader(stringBuilder, logRecord);
        stringBuilder.append(dateFormatter.format(new Date()));
        stringBuilder.append(" : ");
        stringBuilder.append(logRecord.getMessage());
        stringBuilder.append("\n");
        if (logRecord.getThrown() != null) {
            this.appendCause(stringBuilder, logRecord);
        }
        return stringBuilder.toString();
    }

    private void appendCause(StringBuilder stringBuilder, LogRecord logRecord) {
        Throwable throwable = logRecord.getThrown();
        if (throwable instanceof ApplicationException) {
            ExceptionCode exceptionCode = ((ApplicationException)throwable).getExceptionCode();
            this.appendHeader(stringBuilder, logRecord);
            stringBuilder.append(ApplicationContext.getInstance().getExceptionCodesBundle().get(exceptionCode.getIdString()).replaceAll("\n", " "));
            stringBuilder.append(throwable.getMessage());
        } else {
            throwable.printStackTrace();
        }
        stringBuilder.append("\n");
    }

    private void appendHeader(StringBuilder stringBuilder, LogRecord logRecord) {
        stringBuilder.append("[");
        stringBuilder.append(logRecord.getLevel());
        stringBuilder.append("]");
        stringBuilder.append(" : ");
    }
}

