/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.model;

import java.io.File;
import java.util.List;
import java.util.Locale;
import net.sf.amemailchecker.app.model.Language;

public class Settings {
    private String userDataDir;
    private String userPreferencesFile;
    private String userDataFile;
    private String userKeyFile;
    private String userPreferencesFileDefault;
    private String extensionsDir;
    private String extensionsDataDir;
    private String userDownloadsDirDefault;
    private String userDataBaseFile;
    private List<Language> languageData;
    private String langDataPath;
    private String iconDataPath;
    private String aboutDataPath;
    private String dbConnectionDataPath;

    public String getTempDirPath() {
        return System.getProperty("java.io.tmpdir") + File.separator;
    }

    public String getDbConnectionDataPath() {
        return this.dbConnectionDataPath;
    }

    public void setDbConnectionDataPath(String string) {
        this.dbConnectionDataPath = string;
    }

    public String getAboutDataPath() {
        return this.aboutDataPath;
    }

    public void setAboutDataPath(String string) {
        this.aboutDataPath = string;
    }

    public String getLangDataPath() {
        return this.langDataPath;
    }

    public void setLangDataPath(String string) {
        this.langDataPath = string;
    }

    public String getIconDataPath() {
        return this.iconDataPath;
    }

    public void setIconDataPath(String string) {
        this.iconDataPath = string;
    }

    public String getUserPreferencesFileDefault() {
        return this.userPreferencesFileDefault;
    }

    public void setUserPreferencesFileDefault(String string) {
        this.userPreferencesFileDefault = string;
    }

    public String getUserKeyFile() {
        return this.userKeyFile;
    }

    public void setUserKeyFile(String string) {
        this.userKeyFile = string;
    }

    public String getUserDataDir() {
        return this.userDataDir;
    }

    public void setUserDataDir(String string) {
        this.userDataDir = string;
    }

    public String getUserPreferencesFile() {
        return this.userPreferencesFile;
    }

    public void setUserPreferencesFile(String string) {
        this.userPreferencesFile = string;
    }

    public String getUserDataFile() {
        return this.userDataFile;
    }

    public void setUserDataFile(String string) {
        this.userDataFile = string;
    }

    public String getUserHomeDirPath() {
        return System.getProperty("user.home") + File.separator;
    }

    public String getUserDataDirPath() {
        return this.getUserHomeDirPath() + this.userDataDir + File.separator;
    }

    public String getUserPreferencesFilePath() {
        return this.getUserDataDirPath() + this.userPreferencesFile;
    }

    public String getUserDataFilePath() {
        return this.getUserDataDirPath() + this.userDataFile;
    }

    public String getExtensionDataDirPath(String string) {
        return this.getUserDataDirPath() + this.extensionsDataDir + File.separator + string.replaceAll("\\s", "") + File.separator;
    }

    public String getUserKeyFilePath() {
        return this.getUserDataDirPath() + this.userKeyFile;
    }

    public String getUserDownloadsDirDefaultPath() {
        return this.getUserHomeDirPath() + this.userDownloadsDirDefault;
    }

    public String getUserDownloadsDirDefault() {
        return this.userDownloadsDirDefault;
    }

    public void setUserDownloadsDirDefault(String string) {
        this.userDownloadsDirDefault = string;
    }

    public List<Language> getLanguageData() {
        return this.languageData;
    }

    public void setLanguageData(List<Language> list) {
        this.languageData = list;
    }

    public String getExtensionsDir() {
        return this.extensionsDir;
    }

    public void setExtensionsDir(String string) {
        this.extensionsDir = string;
    }

    public String getExtensionsDataDir() {
        return this.extensionsDataDir;
    }

    public void setExtensionsDataDir(String string) {
        this.extensionsDataDir = string;
    }

    public String getUserDataBaseFilePath() {
        return this.getUserDataDirPath() + this.userDataBaseFile + File.separator + this.userDataBaseFile;
    }

    public String getUserDataBaseFile() {
        return this.userDataBaseFile;
    }

    public void setUserDataBaseFile(String string) {
        this.userDataBaseFile = string;
    }

    public int findLanguageIdByLocale(Locale locale) {
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            return 0;
        }
        String string = locale.getLanguage() + "_" + locale.getCountry();
        for (Language language : this.languageData) {
            String string2 = language.getLocaleCode();
            if (!string2.equals(string)) continue;
            return language.getCode();
        }
        return -1;
    }

    public Locale findLocaleByLangId(int n) {
        String string = "";
        for (Language language : this.languageData) {
            if (language.getCode() != n) continue;
            string = language.getLocaleCode();
            break;
        }
        if (string.equals("default")) {
            return Locale.ROOT;
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            String string2 = locale.getLanguage() + "_" + locale.getCountry();
            if (!string2.equals(string)) continue;
            return locale;
        }
        return Locale.ROOT;
    }
}

