/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.model.io;

import java.io.File;
import net.sf.amemailchecker.app.DataNodeName;
import net.sf.amemailchecker.app.model.PersonIdentity;
import net.sf.amemailchecker.app.model.ServerSettings;
import net.sf.amemailchecker.app.model.UserCredentials;
import net.sf.amemailchecker.util.CryptoValueProceeder;
import net.sf.amemailchecker.util.StringUtil;
import org.w3c.dom.Element;

public abstract class AppBaseSettingsReader {
    protected PersonIdentity readPersonIdentity(Element element) {
        PersonIdentity personIdentity = new PersonIdentity();
        personIdentity.setName(element.getElementsByTagName(DataNodeName.NAME.label()).item(0).getTextContent());
        personIdentity.setSurname(element.getElementsByTagName(DataNodeName.SURNAME.label()).item(0).getTextContent());
        personIdentity.setSurnameFirst(Boolean.valueOf(element.getElementsByTagName(DataNodeName.SURNAME_FIRST.label()).item(0).getTextContent()));
        return personIdentity;
    }

    protected ServerSettings readServerSettings(Element element) {
        ServerSettings serverSettings = new ServerSettings();
        serverSettings.setHost(element.getElementsByTagName(DataNodeName.HOST.label()).item(0).getTextContent());
        Element element2 = (Element)element.getElementsByTagName(DataNodeName.PORT.label()).item(0);
        String string = element2.getTextContent();
        serverSettings.setPort(!StringUtil.isNullOrEmpty((String)string) ? Integer.parseInt(string) : 0);
        String string2 = element2.getAttribute("use-default");
        serverSettings.setUseDefaultPort(StringUtil.isNullOrEmpty((String)string2) ? false : Boolean.valueOf(string2));
        serverSettings.setProtocolType(Integer.parseInt(element.getElementsByTagName(DataNodeName.PROTOCOL_TYPE.label()).item(0).getTextContent()));
        return serverSettings;
    }

    protected UserCredentials readUserCredentials(Element element, File file) throws Exception {
        UserCredentials userCredentials = new UserCredentials();
        userCredentials.setUserName(element.getElementsByTagName(DataNodeName.USERNAME.label()).item(0).getTextContent());
        String string = element.getElementsByTagName(DataNodeName.PASSWORD.label()).item(0).getTextContent();
        userCredentials.setPassword(!StringUtil.isNullOrEmpty((String)string) ? CryptoValueProceeder.decodePassword((String)string, (File)file) : null);
        return userCredentials;
    }
}

