/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.model.io;

import java.io.File;
import net.sf.amemailchecker.app.DataNodeName;
import net.sf.amemailchecker.app.model.PersonIdentity;
import net.sf.amemailchecker.app.model.ServerSettings;
import net.sf.amemailchecker.app.model.UserCredentials;
import net.sf.amemailchecker.util.CryptoValueProceeder;
import net.sf.amemailchecker.util.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AppBaseSettingsWriter
extends XmlWriter {
    protected Element createPersonIdentityElement(PersonIdentity personIdentity, Document document) throws Exception {
        Element element = document.createElement(DataNodeName.PERSON_IDENTITY.label());
        this.appendChild(DataNodeName.NAME.label(), personIdentity.getName(), element, document);
        this.appendChild(DataNodeName.SURNAME.label(), personIdentity.getSurname(), element, document);
        this.appendChild(DataNodeName.SURNAME_FIRST.label(), Boolean.toString(personIdentity.isSurnameFirst()), element, document);
        return element;
    }

    protected Element createServerElement(String string, ServerSettings serverSettings, Document document) {
        Element element = document.createElement(string);
        this.appendChild(DataNodeName.HOST.label(), serverSettings.getHost(), element, document);
        String string2 = serverSettings.getPort() > 0 ? Integer.toString(serverSettings.getPort()) : null;
        Element element2 = this.appendChild(DataNodeName.PORT.label(), string2, element, document);
        element2.setAttribute("use-default", Boolean.toString(serverSettings.isUseDefaultPort()));
        this.appendChild(DataNodeName.PROTOCOL_TYPE.label(), Integer.toString(serverSettings.getProtocolType()), element, document);
        return element;
    }

    protected void createUserCredentials(UserCredentials userCredentials, Element element, Document document, File file) throws Exception {
        char[] cArray = userCredentials.getPassword();
        String string = cArray != null && cArray.length > 0 ? CryptoValueProceeder.encodePassword((char[])userCredentials.getPassword(), (File)file) : null;
        this.appendChild(DataNodeName.USERNAME.label(), userCredentials.getUserName(), element, document);
        this.appendChild(DataNodeName.PASSWORD.label(), string, element, document);
    }
}

