/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.model.io;

import java.util.HashMap;
import net.sf.amemailchecker.app.model.PersonIdentity;
import net.sf.amemailchecker.app.model.PersonSignature;
import net.sf.amemailchecker.app.model.PersonalData;
import net.sf.amemailchecker.app.model.io.AppBaseSettingsReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PersonalDataReader
extends AppBaseSettingsReader {
    public PersonalData read(Document document) throws Exception {
        Element element;
        PersonalData personalData = new PersonalData();
        PersonIdentity personIdentity = new PersonIdentity();
        HashMap<String, PersonSignature> hashMap = new HashMap<String, PersonSignature>();
        NodeList nodeList = document.getElementsByTagName("person-identity");
        if (nodeList.getLength() == 1) {
            element = (Element)nodeList.item(0);
            personIdentity = this.readPersonIdentity(element);
        }
        if ((nodeList = document.getElementsByTagName("signatures")).getLength() == 1) {
            element = (Element)nodeList.item(0);
            String string = element.getAttribute("default-id");
            nodeList = element.getElementsByTagName("signature");
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    PersonSignature personSignature = new PersonSignature();
                    personSignature.setUuid(element2.getAttribute("id"));
                    personSignature.setName(element2.getElementsByTagName("name").item(0).getTextContent());
                    personSignature.setBody(element2.getElementsByTagName("body").item(0).getTextContent());
                    hashMap.put(personSignature.getUuid(), personSignature);
                    if (!personSignature.getUuid().equals(string)) continue;
                    personalData.setDefaultSignature(personSignature);
                }
            }
        }
        personalData.setPersonIdentity(personIdentity);
        personalData.setSignatures(hashMap);
        return personalData;
    }
}

