/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.model.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.model.Settings;
import net.sf.amemailchecker.app.model.UserData;
import net.sf.amemailchecker.app.model.UserPreferences;
import net.sf.amemailchecker.gui.messageviewer.MessageViewerPreferences;

public class UserPreferencesHelper {
    private static final Logger logger = Logger.getLogger(UserPreferencesHelper.class.getName());

    public void loadUserPreferences(Settings settings, UserData userData) throws IOException {
        File file = new File(settings.getUserDataDirPath());
        if (!file.exists()) {
            file.mkdir();
        }
        try {
            this.loadPreferences(settings, userData);
        }
        catch (Exception exception) {
            logger.info("user.preferences file is corrupt, deprecated or contains incorrect values. Replacing with defaults...");
            new File(settings.getUserPreferencesFilePath()).delete();
            this.loadPreferences(settings, userData);
        }
    }

    private void loadPreferences(Settings settings, UserData userData) throws IOException {
        InputStream inputStream;
        UserPreferences userPreferences = new UserPreferences();
        MessageViewerPreferences messageViewerPreferences = new MessageViewerPreferences();
        userData.setPreferences(userPreferences);
        userData.setMessageViewerPreferences(messageViewerPreferences);
        Properties properties = new Properties();
        int n = -1;
        try {
            inputStream = new FileInputStream(settings.getUserPreferencesFilePath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(settings.getUserPreferencesFileDefault());
            n = settings.findLanguageIdByLocale(Locale.getDefault());
        }
        properties.load(inputStream);
        inputStream.close();
        userPreferences.setMinCheckInterval(Integer.parseInt(properties.getProperty("minCheckInterval")));
        userPreferences.setNotificationDisplayDelay(Integer.parseInt(properties.getProperty("notificationDisplayDelay")));
        userPreferences.setEntryPointUsed(Integer.parseInt(properties.getProperty("entryPointUsed")));
        userPreferences.setNotificationTypeUsed(Integer.parseInt(properties.getProperty("mailNotificationTypeUsed")));
        userPreferences.setNotificationAnimatingType(Integer.valueOf(properties.getProperty("notificationAnimatingType")));
        userPreferences.setNotificationAlignmentX(Integer.valueOf(properties.getProperty("notificationAlignmentX")));
        userPreferences.setNotificationAlignmentY(Integer.valueOf(properties.getProperty("notificationAlignmentY")));
        userPreferences.setLanguageCode(n == -1 ? Integer.parseInt(properties.getProperty("displayLanguage")) : n);
        userPreferences.setEmptyCacheAccountInactive(Boolean.valueOf(properties.getProperty("emptyCacheAccountInactive")));
        userPreferences.setLook(Integer.valueOf(properties.getProperty("look")));
        String string = properties.getProperty("downloadsDirPath");
        userPreferences.setDownloadsDirPath(string != null ? string : settings.getUserDownloadsDirDefaultPath());
        messageViewerPreferences.setCloseMessageViewerToEntryPoint(Boolean.valueOf(properties.getProperty("closeMessageViewerToEntryPoint")));
        messageViewerPreferences.setRemoveDisabledFromAccountsView(Boolean.valueOf(properties.getProperty("removeDisabledFromAccountsView")));
        messageViewerPreferences.setRemoveDisabledFromFoldersView(Boolean.valueOf(properties.getProperty("removeDisabledFromFoldersView")));
    }

    public void writeUserPreferences(String string, UserData userData) {
        UserPreferences userPreferences = userData.getPreferences();
        MessageViewerPreferences messageViewerPreferences = userData.getMessageViewerPreferences();
        Properties properties = new Properties();
        properties.setProperty("minCheckInterval", Integer.toString(userPreferences.getMinCheckInterval()));
        properties.setProperty("notificationDisplayDelay", Integer.toString(userPreferences.getNotificationDisplayDelay()));
        properties.setProperty("entryPointUsed", Integer.toString(userPreferences.getEntryPointUsed()));
        properties.setProperty("mailNotificationTypeUsed", Integer.toString(userPreferences.getNotificationTypeUsed()));
        properties.setProperty("displayLanguage", Integer.toString(userPreferences.getLanguageCode()));
        properties.setProperty("notificationAnimatingType", Integer.toString(userPreferences.getNotificationAnimatingType()));
        properties.setProperty("notificationAlignmentX", Integer.toString(userPreferences.getNotificationAlignmentX()));
        properties.setProperty("notificationAlignmentY", Integer.toString(userPreferences.getNotificationAlignmentY()));
        properties.setProperty("emptyCacheAccountInactive", Boolean.toString(userPreferences.isEmptyCacheAccountInactive()));
        properties.setProperty("look", Integer.toString(userPreferences.getLook()));
        properties.setProperty("downloadsDirPath", userPreferences.getDownloadsDirPath());
        properties.setProperty("closeMessageViewerToEntryPoint", Boolean.toString(messageViewerPreferences.isCloseMessageViewerToEntryPoint()));
        properties.setProperty("removeDisabledFromAccountsView", Boolean.toString(messageViewerPreferences.isRemoveDisabledFromAccountsView()));
        properties.setProperty("removeDisabledFromFoldersView", Boolean.toString(messageViewerPreferences.isRemoveDisabledFromFoldersView()));
        try {
            FileWriter fileWriter = new FileWriter(string);
            properties.store(fileWriter, "Ame Mail Checker - user preferences");
        }
        catch (IOException iOException) {
            logger.log(Level.INFO, "Unable to write user.preferences file!");
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
    }
}

