/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.model.ui;

import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.sf.amemailchecker.app.model.PersonIdentity;
import net.sf.amemailchecker.app.model.UIPanelModel;

public class PersonIdentityPanelModel
implements UIPanelModel<PersonIdentity> {
    private PersonIdentity personIdentity;
    private PersonIdentity origPersonIdentity;
    private PlainDocument name = new PlainDocument();
    private PlainDocument surname = new PlainDocument();
    private JToggleButton.ToggleButtonModel surnameFirst = new JToggleButton.ToggleButtonModel();

    public PersonIdentityPanelModel(PersonIdentity personIdentity) {
        this.fireModelUpdate(personIdentity);
    }

    public void fill() {
        this.surnameFirst.setSelected(this.personIdentity.isSurnameFirst());
        try {
            this.name.remove(0, this.name.getLength());
            this.surname.remove(0, this.surname.getLength());
            this.name.insertString(0, this.personIdentity.getName(), null);
            this.surname.insertString(0, this.personIdentity.getSurname(), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public PersonIdentity acceptChanges() {
        this.personIdentity.setSurnameFirst(this.surnameFirst.isSelected());
        try {
            this.personIdentity.setName(this.name.getText(0, this.name.getLength()));
            this.personIdentity.setSurname(this.surname.getText(0, this.surname.getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return this.personIdentity;
    }

    public PersonIdentity declineChanges() {
        return this.origPersonIdentity;
    }

    public void fireModelUpdate(PersonIdentity personIdentity) {
        this.personIdentity = personIdentity;
        this.origPersonIdentity = new PersonIdentity(personIdentity);
        this.fill();
    }

    public PlainDocument getNameModel() {
        return this.name;
    }

    public PlainDocument getSurnameModel() {
        return this.surname;
    }

    public JToggleButton.ToggleButtonModel getSurnameFirstModel() {
        return this.surnameFirst;
    }
}

