/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.model.ui;

import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.sf.amemailchecker.app.model.ServerSettings;
import net.sf.amemailchecker.app.model.UIPanelModel;
import net.sf.amemailchecker.app.model.ValueIDComboModel;
import net.sf.amemailchecker.gui.document.IntegerPlainDocument;

public class ServerSettingsPanelModel
implements UIPanelModel<ServerSettings> {
    private ServerSettings serverSettings;
    private PlainDocument hostModel = new PlainDocument();
    private PlainDocument portModel = new IntegerPlainDocument();
    private ValueIDComboModel<Integer> protocolSelectionModel = new ValueIDComboModel();
    private JToggleButton.ToggleButtonModel useDefaultPortModel = new JToggleButton.ToggleButtonModel();

    public ServerSettingsPanelModel(ServerSettings serverSettings) {
        this.fireModelUpdate(serverSettings);
    }

    public void fill() {
        this.useDefaultPortModel.setSelected(this.serverSettings.isUseDefaultPort());
        try {
            this.hostModel.remove(0, this.hostModel.getLength());
            this.hostModel.insertString(0, this.serverSettings.getHost(), null);
            this.portModel.remove(0, this.portModel.getLength());
            if (!this.serverSettings.isUseDefaultPort()) {
                this.portModel.insertString(0, Integer.toString(this.serverSettings.getPort()), null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public ServerSettings acceptChanges() {
        try {
            this.serverSettings.setUseDefaultPort(this.useDefaultPortModel.isSelected());
            this.serverSettings.setHost(this.hostModel.getText(0, this.hostModel.getLength()));
            this.serverSettings.setPort(!this.serverSettings.isUseDefaultPort() ? Integer.valueOf(this.portModel.getText(0, this.portModel.getLength())) : 0);
            this.serverSettings.setProtocolType((Integer)this.protocolSelectionModel.getSelected());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return this.serverSettings;
    }

    public ServerSettings declineChanges() {
        return this.serverSettings;
    }

    public void fireModelUpdate(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
        this.fill();
    }

    public PlainDocument getHostModel() {
        return this.hostModel;
    }

    public PlainDocument getPortModel() {
        return this.portModel;
    }

    public ValueIDComboModel<Integer> getProtocolSelectionModel() {
        return this.protocolSelectionModel;
    }

    public JToggleButton.ToggleButtonModel getUseDefaultPortModel() {
        return this.useDefaultPortModel;
    }
}

