/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.notification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.NotificationContext;
import net.sf.amemailchecker.app.notification.DetailedMailNotification;
import net.sf.amemailchecker.app.notification.NotificationCacheEntry;
import net.sf.amemailchecker.app.notification.NotificationCacheEvent;
import net.sf.amemailchecker.app.notification.SimpleMailNotification;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.util.GenericObservable;

public final class NotificationCache
extends GenericObservable<NotificationCacheEvent>
implements NotificationContext {
    private static NotificationCache instance;
    private Map<String, NotificationCacheEntry> entries = new TreeMap<String, NotificationCacheEntry>();

    public static NotificationCache getInstance() {
        if (instance == null) {
            instance = new NotificationCache();
        }
        return instance;
    }

    private NotificationCache() {
    }

    public boolean isEmpty() {
        for (NotificationCacheEntry notificationCacheEntry : this.entries.values()) {
            if (notificationCacheEntry.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.entries.clear();
    }

    public void clearErrors() {
        for (NotificationCacheEntry notificationCacheEntry : this.entries.values()) {
            notificationCacheEntry.setError(null);
        }
    }

    public void remove(String string) {
        this.entries.remove(string);
    }

    public synchronized void put(String string, Map<Folder, List<Letter>> map) {
        this.find(string).put(map);
    }

    public synchronized void put(Account account, Folder folder, List<Letter> list) {
        this.find(account.getUuid()).put(folder, list);
    }

    public void error(String string, String string2) {
        this.find(string).setError(string2);
    }

    private NotificationCacheEntry find(String string) {
        NotificationCacheEntry notificationCacheEntry = this.entries.get(string);
        if (notificationCacheEntry == null) {
            notificationCacheEntry = new NotificationCacheEntry(string);
            this.entries.put(string, notificationCacheEntry);
        }
        return notificationCacheEntry;
    }

    public Letter get(String string, Folder folder, String string2) {
        return this.find(string).get(folder, string2);
    }

    public List<Letter> get(String string, Folder folder) {
        return this.find(string).get(folder);
    }

    public List<Letter> get(Account account, Folder folder) {
        return this.find(account.getUuid()).get(folder);
    }

    public Map<Folder, List<Letter>> get(Account account) {
        return this.get(account.getUuid());
    }

    public Map<Folder, List<Letter>> get(String string) {
        return this.find(string).getSession();
    }

    public Letter get(String string, String string2) {
        return this.find(string).get(string2);
    }

    public List<Letter> get(String string, boolean bl) {
        return this.find(string).get(bl);
    }

    public int getErrorCount() {
        int n = 0;
        for (NotificationCacheEntry notificationCacheEntry : this.entries.values()) {
            if (notificationCacheEntry.getError() == null) continue;
            ++n;
        }
        return n;
    }

    public int getLastCheckedCount(String string) {
        return this.find(string).getLastCount();
    }

    public int getPersistedCount(String string) {
        return this.find(string).getSessionCount();
    }

    public int getPersistedCount(Account account, Folder folder) {
        return this.contains(account, folder) ? this.find(account.getUuid()).getSession().get(folder).size() : 0;
    }

    public int getLastCheckedCountTotal() {
        int n = 0;
        for (NotificationCacheEntry notificationCacheEntry : this.entries.values()) {
            n += notificationCacheEntry.getLastCount();
        }
        return n;
    }

    public int getPersistedCountTotal() {
        int n = 0;
        for (NotificationCacheEntry notificationCacheEntry : this.entries.values()) {
            n += notificationCacheEntry.getSessionCount();
        }
        return n;
    }

    public List<DetailedMailNotification> getDetailNotificationData() {
        ArrayList<DetailedMailNotification> arrayList = new ArrayList<DetailedMailNotification>();
        for (SimpleMailNotification simpleMailNotification : this.getSimpleNotificationData()) {
            DetailedMailNotification detailedMailNotification = new DetailedMailNotification();
            detailedMailNotification.setCommonNotificationData(simpleMailNotification);
            HashMap<Folder, List<Letter>> hashMap = new HashMap<Folder, List<Letter>>();
            Map<Folder, List<Letter>> map = this.get(simpleMailNotification.getAccount().getUuid());
            if (map != null) {
                hashMap.putAll(map);
            }
            detailedMailNotification.setMessages(hashMap);
            arrayList.add(detailedMailNotification);
        }
        return arrayList;
    }

    public List<SimpleMailNotification> getSimpleNotificationData() {
        ArrayList<SimpleMailNotification> arrayList = new ArrayList<SimpleMailNotification>();
        for (String string : this.entries.keySet()) {
            SimpleMailNotification simpleMailNotification = new SimpleMailNotification();
            simpleMailNotification.setAccount(ApplicationContext.getInstance().getAccountsCache().getByUuid(string));
            simpleMailNotification.setUnreadCount(this.getPersistedCount(string));
            simpleMailNotification.setUnreadNewCount(this.getLastCheckedCount(string));
            simpleMailNotification.setError(this.entries.get(string).getError());
            arrayList.add(simpleMailNotification);
        }
        return arrayList;
    }

    public boolean isError() {
        return this.getErrorCount() == this.entries.size() && this.entries.size() > 0;
    }

    public Map<Folder, List<String>> getUidList(String string) {
        Map<Folder, List<Letter>> map = this.get(string);
        if (map == null) {
            return null;
        }
        HashMap<Folder, List<String>> hashMap = new HashMap<Folder, List<String>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Folder folder : map.keySet()) {
            for (Letter letter : map.get(folder)) {
                arrayList.add(letter.getUid());
            }
            hashMap.put(folder, arrayList);
        }
        return hashMap;
    }

    public void remove(String string, Map<Folder, List<String>> map) {
        if (map == null) {
            return;
        }
        NotificationCacheEntry notificationCacheEntry = this.entries.get(string);
        for (Folder folder : map.keySet()) {
            for (String string2 : map.get(folder)) {
                notificationCacheEntry.remove(folder, string2);
            }
        }
    }

    public void remove(String string, Folder folder) {
        this.find(string).remove(folder);
    }

    public boolean contains(String string) {
        return this.entries.containsKey(string);
    }

    public boolean contains(Account account, Folder folder) {
        if (!this.contains(account.getUuid())) {
            return false;
        }
        return this.entries.get(account.getUuid()).contains(folder);
    }

    public boolean containsLetters(Account account, Folder folder) {
        return this.getPersistedCount(account, folder) > 0;
    }

    public synchronized void fireObserverUpdate(NotificationCacheEvent notificationCacheEvent) {
        this.setChanged();
        this.notifyObservers(notificationCacheEvent);
    }
}

